package com.jispot.services.impl;

import java.util.logging.Logger;

import org.springframework.stereotype.Service;

import com.jispot.common.Hash;
import com.jispot.common.StringUtils;
import com.jispot.domain.model.Apikey;
import com.jispot.domain.model.Application;
import com.jispot.services.ApplicationService;
import com.jispot.services.ConnectionService;

@Service("applicationService")
public class ApplicationServiceImpl implements ApplicationService {

	protected final Logger log = Logger.getLogger(this.getClass().getName());

	public Application get(Long id) {
		return Application.all().filter("id", id).get();
	}

	public boolean secretKeyExists(String secretKey) {
		String hashedSecretKey = Hash.hacher(secretKey, Hash.HASH_SHA_512);
		Application obj = Application.all().filter("secret_key", hashedSecretKey).get();
		return ( obj !=null && obj.id != null );
	}

	/**
	 * Return the secret Hashed
	 * @param apiKey
	 * @return
	 */
	public String getSecret(Long appliId) {
		Application obj = Application.all().filter("id", appliId).get();
		return obj != null ? obj.secretKey : null;
	}

	public void create(final String name, final String description, final String password) {

		String generatedApiKey = StringUtils.getRandomText( 64 );
		String generatedSecretKey = StringUtils.getRandomText( 128 );

		Application obj = new Application();
		obj.name = name;
		obj.description = description;
		obj.secretKey = Hash.hacher(generatedSecretKey, Hash.HASH_SHA_512);
		obj.insert();
		
		Apikey ak = new Apikey();
		ak.application = obj;
		ak.key = generatedApiKey;
		ak.valid = true;
		ak.insert();
		
		// if everything is OK we have to transmit the API key and the secretKey to the user/application
	}

}
