package com.jispot.common;

import java.util.Date;

@SuppressWarnings( "unchecked" )
public class Param implements Comparable {

    private final String name;
    private final String value;

    public Param( String name , String value ) {
        this.name = name;
        this.value = value;
    }

    public Param( String name , Date value ) {
        this.name = name;
        this.value = String.valueOf( value.getTime() );
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public int compareTo( Object param ) {
        return name.compareTo( ( ( Param ) param ).getName() );
    }

    /**
     * Return the concatenation of name + value
     * @return name + value
     */
    @Override
    public String toString() {
        if (name == null || value == null) {
            return null;
        }
        return (name + value).toLowerCase();
    }
    
}
