package com.jispot.common;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class EmailUtils {

	protected static final Logger log = Logger.getLogger( EmailUtils.class.getName() );

	private static final String FROM_EMAIL = "noreply@jispot.me";

	private static final String FROM_NAME = "JISPOT - NO REPLY";

	public static void send(String toEmail, String toName, String subject, String body) {
		Map<String,String> toMap = new HashMap<String,String>(2);
		toMap.put(toEmail, toName);
		EmailUtils.send(toMap, subject, body );
	}

	public static void send(Map<String,String> toMap, String subject, String body) {
		EmailUtils.send(FROM_EMAIL, FROM_NAME, toMap, subject, body );
	}

	public static void send(String fromEmail, String fromName, String toEmail, String toName, String subject, String body) {
		Map<String,String> toMap = new HashMap<String,String>(2);
		toMap.put(toEmail, toName);
		EmailUtils.send(fromEmail, fromName, toMap, subject, body );
	}

	public static void send(String fromEmail, String fromName,
			Map<String, String> toMap, String subject, String body) {
		Properties props = new Properties();
		Session session = Session.getDefaultInstance(props, null);
		try {
			Message msg = new MimeMessage(session);
			msg.setFrom(new InternetAddress(fromEmail, fromName));

			Iterator<String> ite = toMap.keySet().iterator();
			while (ite.hasNext()) {
				String toMail = ite.next();
				String toName = toMap.get(toMail);
				msg.addRecipient(Message.RecipientType.TO, new InternetAddress(
						toMail, toName));
			}

			msg.setSubject(subject);
			msg.setText(body);
			Transport.send(msg);
		} catch (Exception ex) {
			log.log(Level.WARNING, "Could not send email", ex);
		}
	}
}
