package com.jispot.web.spot;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.jispot.web.JISpotAjaxController;
import com.jispot.web.vo.FastSearchResultVO;

@Controller("searchSpotController")
public class SearchSpotController extends JISpotAjaxController {

    protected final Logger log = Logger.getLogger(this.getClass().getName());

    /**
     * Retourne un marqueur sur la position courante du spotter.
     */
    @RequestMapping(value = "/jispot/nearlist.html")
    public void nearlist(HttpServletRequest request, HttpServletResponse response,
            @RequestParam(value = "q", required = false) final String input) {
        super.init(request, response);
        log.info("SearchSpotController.nearlist called!");
        log.info("Input : " + input);
                
        // Here we have to get all the nearest things for the current user... that's all.
//      List<String> result = new ArrayList<String>();
//      result.add("Tata | General");
//      result.add("Tete | Colonel");
//      result.add("Titi | Lieutenant");
//      result.add("Toto | Capitaine");
//      result.add("Tutu | Sergent");
//      result.add("Tyty | Adjudant");

//      List<String> result = new ArrayList<String>();
//      result.add("General");
//      result.add("Colonel");
//      result.add("Lieutenant");
//      result.add("Capitaine");
//      result.add("Sergent");
//      result.add("Adjudant");

      List<FastSearchResultVO> result = new ArrayList<FastSearchResultVO>();
      result.add(new FastSearchResultVO( "1", "Luc Skywalker", "General"));
      result.add(new FastSearchResultVO( "2", "Darth Vador", "Colonel"));
      result.add(new FastSearchResultVO( "3", "Master Yoda", "Lieutenant"));
      result.add(new FastSearchResultVO( "4", "Obi One Kenobi", "Capitaine"));
      result.add(new FastSearchResultVO( "5", "Darth Maul", "Sergent"));
      result.add(new FastSearchResultVO( "6", "The Emperor", "Adjudant"));
      result.add(new FastSearchResultVO( "7", "Princess Lea", "General"));

//        Map<String,String> result = new HashMap<String,String>();
//        result.put("Tata" , "General");
//        result.put("Tete" , "Colonel");
//        result.put("Titi" , "Lieutenant");
//        result.put("Toto" , "Capitaine");
//        result.put("Tutu" , "Sergent");
//        result.put("Tyty" , "Adjudant");
      
        super.sendJsonResult(result);
    }
    
}
