package com.jispot.common;

import java.security.MessageDigest;

public class Hash {

	public static final String HASH_MD2 = "MD2";
	public static final int HASH_MD2_SIZE = 32;
	public static final String HASH_MD5 = "MD5";
	public static final int HASH_MD5_SIZE = 32;
	public static final String HASH_SHA_1 = "SHA-1";
	public static final int HASH_SHA_1_SIZE = 40;
	public static final String HASH_SHA_256 = "SHA-256";
	public static final int HASH_SHA_256_SIZE = 64;
	public static final String HASH_SHA_384 = "SHA-384";
	public static final int HASH_SHA_384_SIZE = 96;
	public static final String HASH_SHA_512 = "SHA-512";
	public static final int HASH_SHA_512_SIZE = 128;

	/**
	 * @param args
	 */
	public static void main(String[] args) throws Exception {
		// TODO Auto-generated method stub
		System.out.println(Hash.hacher("toto"));
		System.out.println(StringUtils.getRandomText(64));
	}

	// ******************************************************************
	// ******************************************************************

	/**
	 * Renvoie l' "empreinte" resultant du hachage, par la fonction specifiee
	 * (SHA-2 pour l'instant), du texte en parametre ; retourne la conversion
	 * hexadecimale de ses bits UTF-8 'non-signes' (sur 64 caracteres si
	 * SHA-256).
	 * 
	 * @see #hacher(String, byte[])
	 */
	public static String hacher(String texte) throws Exception {
		return hacher(texte, HASH_SHA_256);
	}

	/**
	 * Renvoie l' "empreinte" resultant du hachage, par la fonction specifiee
	 * par algo, du texte en parametre ; retourne la conversion hexadecimale de
	 * ses bits UTF-8 'non-signes' (sur 64 caracteres si SHA-256).
	 * 
	 * @see #hacher(String, byte[])
	 */
	public static String hacher(String texte, String algo) {
		try {
			String hashed = null;
			byte[] empreinte = hacher(texte.getBytes("UTF-8"), algo);
			hashed = Hash.byteToHex(empreinte);
			return hashed;
		} catch (Exception e) {
			return null;
		}
	}

	/**
	 * Renvoie l' "empreinte" resultant du hachage, par la fonction specifiee
	 * (si disponible), du message en parametre.
	 */
	private static byte[] hacher(byte[] message, String algo) {
		try {
			MessageDigest fabrique = MessageDigest.getInstance(algo);
			fabrique.update(message);
			return fabrique.digest();
		} catch (Exception e) {
			return null;
		}
	}

	/**
	 * Convertit des octets en leur representation hexadecimale (base 16),
	 * chacun se retrouvant finalement 'non signe' et sur 2 caracteres.
	 * 
	 * @see http
	 *      ://java.sun.com/developer/technicalArticles/Security/AES/AES_v1.html
	 */
	public static String byteToHex(byte[] bits) throws Exception {
		if (bits == null) {
			return null;
		}
		StringBuffer hex = new StringBuffer(bits.length * 2); // encod(1_bit) =>
																// 2 digits
		for (int i = 0; i < bits.length; i++) {
			if (((int) bits[i] & 0xff) < 0x10) { // 0 < .. < 9
				hex.append("0");
			}
			hex.append(Integer.toString((int) bits[i] & 0xff, 16)); // [(bit+256)%256]^16
		}
		return hex.toString();
	}
}
