/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.jdbc.internal;

import com.google.cloud.sql.jdbc.internal.SQLFeatureNotYetImplementedException;
import com.google.cloud.sql.jdbc.internal.SqlState;
import com.google.protos.cloud.sql.Client;
import java.sql.ClientInfoStatus;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLNonTransientException;
import java.sql.SQLRecoverableException;
import java.sql.SQLTransientException;
import java.text.MessageFormat;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Exceptions {
    public static final String BAD_URL_FORMAT = "URL is not in the correct format: {0}";
    public static final String INVALID_PARAMETER = "Invalid parameter for {0} value {1}.";
    public static final String INVALID_PARAMETER_FOR_TYPE = "Invalid parameter for {0} type {1}.";
    public static final String INVALID_PARAMETER_MESSAGE = "Invalid parameter for {0} value {1}. {2}";
    private static final Client.SqlException TIMEOUT = Client.SqlException.newBuilder().setApplicationErrorCode(1002).setCode(0).setMessage("Operation timed out.").build();

    private Exceptions() {
    }

    public static SQLException newTimeoutException() {
        return Exceptions.newSqlException(TIMEOUT);
    }

    public static SQLException newConnectionClosedException() {
        return new SQLException("This Connection is closed.");
    }

    public static SQLException newResultSetClosedException() {
        return new SQLException("This ResultSet is closed.");
    }

    public static SQLException newStatementClosedException() {
        return new SQLException("This Statement is closed.");
    }

    public static SQLClientInfoException newClientInfoConnectionClosedException() {
        return new SQLClientInfoException("This connection is Closed", Collections.<String, ClientInfoStatus>emptyMap());
    }

    public static SQLClientInfoException newClientInfoNotSupportedException() {
        return new SQLClientInfoException("ClientInfo is not supported.", Collections.<String, ClientInfoStatus>emptyMap());
    }

    public static SQLException newStatementExecuteQueryNullResultSetException() {
        return new SQLException("The ResultSet can not be null for Statement.executeQuery.");
    }

    public static SQLException newStatementExecuteUpdateWithResultSetException() {
        return new SQLException("The ResultSet must be be null for Statement.executeUpdate.");
    }

    public static SQLException newDriverCanNotConnectException() {
        return new SQLException("Unable to connect to server.", "08001");
    }

    public static SQLException newErrorFetchingMetadataException() {
        return new SQLException("Error fetching metadata.");
    }

    public static final SQLFeatureNotYetImplementedException newNotYetImplementedException() {
        return Exceptions.newNotYetImplementedException("This feature is not implemented yet.");
    }

    public static final SQLFeatureNotYetImplementedException newNotYetImplementedException(String message) {
        return new SQLFeatureNotYetImplementedException(message);
    }

    public static final SQLFeatureNotSupportedException newNotSupportedException(String message) {
        return new SQLFeatureNotSupportedException(message);
    }

    public static SQLException resultSetDoesNotHaveColumn(Object nameOrNumber) {
        return new SQLException("ResultSet does not have a column " + nameOrNumber);
    }

    public static SQLException driverUrlNotInCorrectFormat(String url) {
        return new SQLException(MessageFormat.format(BAD_URL_FORMAT, url), "08006");
    }

    public static SQLException newInvalidParameterException(String fieldName, Object value) {
        return new SQLException(MessageFormat.format(INVALID_PARAMETER, fieldName, value), "22023");
    }

    public static SQLException newInvalidParameterException(String methodName, Class<?> clazz) {
        return new SQLException(MessageFormat.format(INVALID_PARAMETER_FOR_TYPE, methodName, clazz.getCanonicalName()), "22023");
    }

    public static SQLException newInvalidParameterException(String fieldName, Object value, String message) {
        return new SQLException(MessageFormat.format(INVALID_PARAMETER_MESSAGE, fieldName, value, message), "22023");
    }

    public static SQLException newInvalidParameterException(String message) {
        return new SQLException(message, "22023");
    }

    public static SQLException newSqlException(String message) {
        return new SQLException(message);
    }

    public static SQLException newSqlException(String message, Throwable cause) {
        return new SQLException(message + ": " + cause.getMessage());
    }

    private static String getSqlState(Client.SqlException e) {
        if (e.hasApplicationErrorCode()) {
            return SqlState.forError(e.getApplicationErrorCode());
        }
        return e.hasSqlState() ? e.getSqlState() : null;
    }

    public static SQLException newSqlExceptionForApplicationError(Client.SqlException e) {
        if (!e.hasApplicationErrorCode()) {
            return null;
        }
        int code = e.getApplicationErrorCode();
        String sqlState = Exceptions.getSqlState(e);
        switch (code) {
            case 1: 
            case 1038: {
                return new SQLTransientException(e.getMessage(), sqlState, code);
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 1001: 
            case 1002: 
            case 1005: 
            case 1006: 
            case 1008: 
            case 1009: 
            case 1010: 
            case 1020: 
            case 1033: 
            case 1034: 
            case 1035: 
            case 1037: {
                return new SQLNonTransientException(e.getMessage(), sqlState, code);
            }
            case 5: 
            case 1003: 
            case 1004: 
            case 1032: {
                return new SQLInvalidAuthorizationSpecException(e.getMessage(), sqlState, code);
            }
            case 1007: {
                return new SQLNonTransientConnectionException(e.getMessage(), sqlState, code);
            }
            case 1036: {
                return new SQLRecoverableException(e.getMessage(), sqlState, code);
            }
            case 1030: {
                return new SQLFeatureNotYetImplementedException(e.getMessage());
            }
            case 1031: {
                return new SQLFeatureNotSupportedException(e.getMessage(), sqlState, code);
            }
        }
        return null;
    }

    public static SQLException newSqlException(Client.SqlException e) {
        SQLException ex = Exceptions.newSqlExceptionForApplicationError(e);
        if (ex != null) {
            return ex;
        }
        return new SQLException(e.getMessage(), Exceptions.getSqlState(e), e.getCode());
    }

    public static SQLException newNotSupportedOnForwardOnlyException() {
        return new SQLException("This method is not allowed on a forward only resultset.", "0A000");
    }
}

