/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.utils;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FutureWrapper<K, V>
implements Future<V> {
    private final Future<K> parent;
    private boolean hasResult;
    private V result;
    private final Lock lock = new ReentrantLock();

    public FutureWrapper(Future<K> parent) {
        this.parent = parent;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.parent.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.parent.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.parent.isDone();
    }

    private V wrapAndCache(K data) throws ExecutionException {
        try {
            this.result = this.wrap(data);
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
        this.hasResult = true;
        return this.result;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        this.lock.lock();
        try {
            if (this.hasResult) {
                V v = this.result;
                return v;
            }
            V v = this.wrapAndCache(this.parent.get());
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
        long tryLockStart = System.currentTimeMillis();
        if (!this.lock.tryLock(timeout, unit)) {
            throw new TimeoutException();
        }
        try {
            V v;
            if (this.hasResult) {
                V v2 = this.result;
                return v2;
            }
            long remainingDeadline = TimeUnit.MILLISECONDS.convert(timeout, unit) - (System.currentTimeMillis() - tryLockStart);
            try {
                v = this.wrapAndCache(this.parent.get(remainingDeadline, TimeUnit.MILLISECONDS));
            }
            catch (ExecutionException ex) {
                throw new ExecutionException(this.convertException(ex.getCause()));
            }
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    protected abstract V wrap(K var1) throws Exception;

    protected abstract Throwable convertException(Throwable var1);
}

