/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.files;

import com.google.appengine.api.files.AppEngineFile;
import com.google.appengine.api.files.FileReadChannel;
import com.google.appengine.api.files.FileServiceImpl;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;

class FileReadChannelImpl
implements FileReadChannel {
    private FileServiceImpl fileService;
    private AppEngineFile file;
    private long position;
    private boolean isOpen;

    FileReadChannelImpl(AppEngineFile f, FileServiceImpl fs) {
        this.file = f;
        this.fileService = fs;
        this.isOpen = true;
        if (null == this.file) {
            throw new NullPointerException("file is null");
        }
        if (null == fs) {
            throw new NullPointerException("fs is null");
        }
    }

    private void checkOpen() throws ClosedChannelException {
        if (!this.isOpen) {
            throw new ClosedChannelException();
        }
    }

    public long position() throws IOException {
        this.checkOpen();
        return this.position;
    }

    public FileReadChannel position(long newPosition) throws IOException {
        if (newPosition < 0L) {
            throw new IllegalArgumentException("newPosition may not be negative");
        }
        this.checkOpen();
        this.position = newPosition;
        return this;
    }

    public int read(ByteBuffer dst) throws IOException {
        if (this.position < 0L) {
            return -1;
        }
        int numBytesRead = this.fileService.read(this.file, dst, this.position);
        this.position = numBytesRead >= 0 ? (this.position += (long)numBytesRead) : -1L;
        return numBytesRead;
    }

    public boolean isOpen() {
        return false;
    }

    public void close() throws IOException {
        if (!this.isOpen) {
            return;
        }
        this.fileService.close(this.file, false);
        this.isOpen = false;
    }
}

