/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.DatastoreApiHelper;
import com.google.appengine.api.datastore.FutureHelper;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionStack;
import com.google.appengine.api.utils.FutureWrapper;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.apphosting.api.ApiBasePb;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.DatastorePb;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TransactionImpl
implements Transaction {
    private final ApiProxy.ApiConfig apiConfig;
    private final String app;
    private final Future<DatastorePb.Transaction> future;
    private final TransactionStack txnStack;
    TransactionState state = TransactionState.BEGUN;

    TransactionImpl(ApiProxy.ApiConfig apiConfig, String app, Future<DatastorePb.Transaction> future, TransactionStack txnStack) {
        this.apiConfig = apiConfig;
        this.app = app;
        this.future = future;
        this.txnStack = txnStack;
    }

    private long getHandle() {
        return FutureHelper.quietGet(this.future).getHandle();
    }

    <T extends ProtocolMessage<T>> Future<T> makeAsyncCall(String methodName, ProtocolMessage<?> request, T response) {
        return DatastoreApiHelper.makeAsyncCall(this.apiConfig, methodName, request, response);
    }

    private <T extends ProtocolMessage<T>> Future<T> makeAsyncCall(String methodName, T response) {
        DatastorePb.Transaction txn = new DatastorePb.Transaction();
        txn.setApp(this.app);
        txn.setHandle(this.getHandle());
        return this.makeAsyncCall(methodName, txn, response);
    }

    @Override
    public void commit() {
        FutureHelper.quietGet(this.commitAsync());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> commitAsync() {
        this.ensureTxnStarted();
        this.state = TransactionState.COMPLETION_IN_PROGRESS;
        try {
            for (Future futureWrapper : this.txnStack.getFutures(this)) {
                FutureHelper.quietGet(futureWrapper);
            }
            Future<DatastorePb.CommitResponse> future = this.makeAsyncCall("Commit", new DatastorePb.CommitResponse());
            FutureWrapper<DatastorePb.CommitResponse, Void> futureWrapper = new FutureWrapper<DatastorePb.CommitResponse, Void>(future){

                @Override
                protected Void wrap(DatastorePb.CommitResponse ignore) throws Exception {
                    TransactionImpl.this.state = TransactionState.COMMITTED;
                    return null;
                }

                @Override
                protected Throwable convertException(Throwable cause) {
                    TransactionImpl.this.state = TransactionState.ERROR;
                    return cause;
                }
            };
            return futureWrapper;
        }
        finally {
            this.txnStack.remove(this);
        }
    }

    @Override
    public void rollback() {
        FutureHelper.quietGet(this.rollbackAsync());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> rollbackAsync() {
        this.ensureTxnStarted();
        this.state = TransactionState.COMPLETION_IN_PROGRESS;
        try {
            for (Future futureWrapper : this.txnStack.getFutures(this)) {
                FutureHelper.quietGet(futureWrapper);
            }
            Future<ApiBasePb.VoidProto> future = this.makeAsyncCall("Rollback", new ApiBasePb.VoidProto());
            FutureWrapper<ApiBasePb.VoidProto, Void> futureWrapper = new FutureWrapper<ApiBasePb.VoidProto, Void>(future){

                @Override
                protected Void wrap(ApiBasePb.VoidProto ignore) throws Exception {
                    TransactionImpl.this.state = TransactionState.ROLLED_BACK;
                    return null;
                }

                @Override
                protected Throwable convertException(Throwable cause) {
                    TransactionImpl.this.state = TransactionState.ERROR;
                    return cause;
                }
            };
            return futureWrapper;
        }
        finally {
            this.txnStack.remove(this);
        }
    }

    @Override
    public String getApp() {
        return this.app;
    }

    @Override
    public String getId() {
        return Long.toString(this.getHandle());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionImpl that = (TransactionImpl)o;
        return this.getHandle() == that.getHandle();
    }

    public int hashCode() {
        return (int)(this.getHandle() ^ this.getHandle() >>> 32);
    }

    public String toString() {
        return "Txn [" + this.app + "." + this.getHandle() + ", " + (Object)((Object)this.state) + "]";
    }

    @Override
    public boolean isActive() {
        return this.state == TransactionState.BEGUN || this.state == TransactionState.COMPLETION_IN_PROGRESS;
    }

    static void ensureTxnActive(Transaction txn) {
        if (txn != null && !txn.isActive()) {
            throw new IllegalStateException("Transaction with which this operation is associated is not active.");
        }
    }

    private void ensureTxnStarted() {
        if (this.state != TransactionState.BEGUN) {
            throw new IllegalStateException("Transaction is in state " + (Object)((Object)this.state) + ".  There is no legal " + "transition out of this state.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TransactionState {
        BEGUN,
        COMPLETION_IN_PROGRESS,
        COMMITTED,
        ROLLED_BACK,
        ERROR;

    }
}

