/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.metadata;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.metadata.GenericTableMetaDataProvider;

public class OracleTableMetaDataProvider
extends GenericTableMetaDataProvider {
    private boolean includeSynonyms;

    public OracleTableMetaDataProvider(DatabaseMetaData databaseMetaData) throws SQLException {
        this(databaseMetaData, false);
    }

    public OracleTableMetaDataProvider(DatabaseMetaData databaseMetaData, boolean includeSynonyms) throws SQLException {
        super(databaseMetaData);
        this.includeSynonyms = includeSynonyms;
    }

    public void initializeWithTableColumnMetaData(DatabaseMetaData databaseMetaData, String catalogName, String schemaName, String tableName) throws SQLException {
        Connection con = databaseMetaData.getConnection();
        Method methodToInvoke = null;
        Boolean origValueForIncludeSynonyms = null;
        if (this.includeSynonyms) {
            if (con.getClass().getName().startsWith("oracle")) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Including synonyms in table metadata lookup.");
                }
            } else {
                logger.warn((Object)("Unable to include synonyms in table metadata lookup. Connection used for DatabaseMetaData is not recognized as an Oracle connection; class is " + con.getClass().getName()));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)"Defaulting to no synonyms in table metadata lookup.");
        }
        if (this.includeSynonyms && con.getClass().getName().startsWith("oracle")) {
            try {
                methodToInvoke = con.getClass().getMethod("getIncludeSynonyms", null);
                methodToInvoke.setAccessible(true);
                origValueForIncludeSynonyms = (Boolean)methodToInvoke.invoke((Object)con, new Object[0]);
                methodToInvoke = con.getClass().getMethod("setIncludeSynonyms", Boolean.TYPE);
                methodToInvoke.setAccessible(true);
                methodToInvoke.invoke((Object)con, Boolean.TRUE);
            }
            catch (Exception ex) {
                throw new InvalidDataAccessApiUsageException("Couldn't initialize Oracle Connection.", (Throwable)ex);
            }
        }
        super.initializeWithTableColumnMetaData(databaseMetaData, catalogName, schemaName, tableName);
        if (this.includeSynonyms && con.getClass().getName().startsWith("oracle")) {
            try {
                methodToInvoke = con.getClass().getMethod("setIncludeSynonyms", Boolean.TYPE);
                methodToInvoke.setAccessible(true);
                methodToInvoke.invoke((Object)con, origValueForIncludeSynonyms);
            }
            catch (Exception ex) {
                throw new InvalidDataAccessApiUsageException("Couldn't restore Oracle Connection.", (Throwable)ex);
            }
        }
    }
}

