/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.validator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class CompoundValidator
implements Validator {
    private List validators;

    public CompoundValidator() {
        this(new Validator[0]);
    }

    public CompoundValidator(Validator[] validators) {
        this.setValidators(validators);
    }

    public boolean supports(Class clazz) {
        Iterator i = this.validators.iterator();
        while (i.hasNext()) {
            Validator validator = (Validator)i.next();
            if (!validator.supports(clazz)) continue;
            return true;
        }
        return false;
    }

    public void validate(Object obj, Errors errors) {
        Iterator i = this.validators.iterator();
        while (i.hasNext()) {
            Validator validator = (Validator)i.next();
            if (!validator.supports(obj.getClass())) continue;
            validator.validate(obj, errors);
        }
    }

    public void addValidator(Validator validator) {
        this.validators.add(validator);
    }

    public void addValidators(Validator[] validators) {
        for (int i = 0; i < validators.length; ++i) {
            this.addValidator(validators[i]);
        }
    }

    public void setValidators(Validator[] validators) {
        ArrayList<Validator> validatorList = new ArrayList<Validator>(validators.length);
        for (int i = 0; i < validators.length; ++i) {
            validatorList.add(validators[i]);
        }
        this.validators = validatorList;
    }
}

