/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.util.fel.parser;

import ognl.Ognl;
import ognl.OgnlException;
import org.springmodules.validation.util.fel.FelEvaluationException;
import org.springmodules.validation.util.fel.FelParseException;
import org.springmodules.validation.util.fel.Function;
import org.springmodules.validation.util.fel.FunctionExpressionParser;

public class OgnlFunctionExpressionParser
implements FunctionExpressionParser {
    public Function parse(String expression) {
        return new OgnlFunction(expression);
    }

    protected class OgnlFunction
    implements Function {
        private String expressionAsString;
        private Object ognlExpression;

        public OgnlFunction(String expressionAsString) {
            this.expressionAsString = expressionAsString;
            try {
                this.ognlExpression = Ognl.parseExpression((String)expressionAsString);
            }
            catch (OgnlException oe) {
                throw new FelParseException("Could not parse OGNL expression '" + expressionAsString + "'", oe);
            }
        }

        public Object evaluate(Object argument) {
            try {
                return Ognl.getValue((Object)this.ognlExpression, (Object)argument);
            }
            catch (OgnlException oe) {
                throw new FelEvaluationException("Could not evaluate OGNL expression '" + this.expressionAsString + "' on argument '" + String.valueOf(argument), oe);
            }
        }
    }
}

