/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine.query;

import com.google.appengine.api.datastore.Entity;
import java.util.Iterator;
import org.datanucleus.store.appengine.Utils;
import org.datanucleus.store.appengine.query.QueryExceptionWrappers;
import org.datanucleus.store.appengine.query.RuntimeExceptionObserver;
import org.datanucleus.store.appengine.query.RuntimeExceptionWrappingIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RuntimeExceptionWrappingIterable
implements Iterable<Entity>,
RuntimeExceptionObserver {
    private final boolean isJPA;
    private final Utils.Supplier<Iterator<Entity>> iteratorSupplier;
    private boolean hasError = false;

    RuntimeExceptionWrappingIterable(final Iterable<Entity> inner, boolean isJPA) {
        if (inner == null) {
            throw new NullPointerException("inner cannot be null");
        }
        this.isJPA = isJPA;
        Utils.Supplier<Iterator<Entity>> supplier = QueryExceptionWrappers.datastoreToDataNucleus(new Utils.Supplier<Iterator<Entity>>(){

            @Override
            public Iterator<Entity> get() {
                return RuntimeExceptionWrappingIterable.this.newIterator(inner.iterator());
            }
        });
        this.iteratorSupplier = isJPA ? QueryExceptionWrappers.dataNucleusToJPA(supplier) : QueryExceptionWrappers.dataNucleusToJDO(supplier);
    }

    @Override
    public Iterator<Entity> iterator() {
        return this.iteratorSupplier.get();
    }

    Iterator<Entity> newIterator(Iterator<Entity> innerIter) {
        return new RuntimeExceptionWrappingIterator(innerIter, this.isJPA, this);
    }

    @Override
    public void onException() {
        this.hasError = true;
    }

    boolean hasError() {
        return this.hasError;
    }
}

