/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine;

import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceConfig;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.Query;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.store.appengine.DatastoreManager;
import org.datanucleus.store.appengine.DatastorePersistenceHandler;
import org.datanucleus.store.appengine.DatastoreServiceFactoryInternal;
import org.datanucleus.store.appengine.query.DatastoreQuery;
import org.datanucleus.store.mapped.scostore.BaseElementContainerStoreSpecialization;
import org.datanucleus.store.mapped.scostore.ElementContainerStore;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class DatastoreElementContainerStoreSpecialization
extends BaseElementContainerStoreSpecialization {
    private static final NucleusLogger logger = NucleusLogger.DATASTORE_RETRIEVE;
    final DatastoreManager storeMgr;

    DatastoreElementContainerStoreSpecialization(Localiser localiser, ClassLoaderResolver clr, DatastoreManager storeMgr) {
        super(localiser, clr);
        this.storeMgr = storeMgr;
    }

    public void executeClear(StateManager ownerSM, ElementContainerStore elementContainerStore) {
    }

    public int getSize(StateManager sm, ElementContainerStore ecs) {
        DatastorePersistenceHandler handler = this.storeMgr.getPersistenceHandler();
        Entity parentEntity = handler.getAssociatedEntityForCurrentTransaction(sm);
        if (parentEntity == null) {
            handler.locateObject(sm);
            parentEntity = handler.getAssociatedEntityForCurrentTransaction(sm);
        }
        return this.getNumChildren(parentEntity.getKey(), ecs);
    }

    PreparedQuery prepareChildrenQuery(Key parentKey, Iterable<Query.FilterPredicate> filterPredicates, Iterable<Query.SortPredicate> sortPredicates, boolean keysOnly, ElementContainerStore ecs) {
        String kind = ecs.getContainerTable().getIdentifier().getIdentifierName();
        Query q = new Query(kind, parentKey);
        if (keysOnly) {
            q.setKeysOnly();
        }
        logger.debug((Object)("Preparing to query for all children of " + parentKey + " of kind " + kind));
        for (Query.FilterPredicate fp : filterPredicates) {
            q.addFilter(fp.getPropertyName(), fp.getOperator(), fp.getValue());
            logger.debug((Object)("  Added filter: " + fp.getPropertyName() + " " + fp.getOperator() + " " + fp.getValue()));
        }
        for (Query.SortPredicate sp : sortPredicates) {
            q.addSort(sp.getPropertyName(), sp.getDirection());
            logger.debug((Object)("  Added sort: " + sp.getPropertyName() + " " + sp.getDirection()));
        }
        DatastoreServiceConfig config = this.storeMgr.getDefaultDatastoreServiceConfigForReads();
        DatastoreService ds = DatastoreServiceFactoryInternal.getDatastoreService(config);
        return ds.prepare(q);
    }

    List<?> getChildren(Key parentKey, Iterable<Query.FilterPredicate> filterPredicates, Iterable<Query.SortPredicate> sortPredicates, ElementContainerStore ecs, ObjectManager om) {
        ArrayList<Object> result = new ArrayList<Object>();
        int numChildren = 0;
        for (Entity e : this.prepareChildrenQuery(parentKey, filterPredicates, sortPredicates, false, ecs).asIterable()) {
            if (!parentKey.equals((Object)e.getKey().getParent())) continue;
            ++numChildren;
            result.add(DatastoreQuery.entityToPojo(e, ecs.getEmd(), this.clr, om, false, om.getFetchPlan()));
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Retrieved entity with key " + e.getKey()));
        }
        logger.debug((Object)String.format("Query had %d result%s.", numChildren, numChildren == 1 ? "" : "s"));
        return result;
    }

    int getNumChildren(Key parentKey, ElementContainerStore ecs) {
        Iterable children = this.prepareChildrenQuery(parentKey, Collections.<Query.FilterPredicate>emptyList(), Collections.<Query.SortPredicate>emptyList(), true, ecs).asIterable();
        int count = 0;
        for (Entity e : children) {
            if (!parentKey.equals((Object)e.getKey().getParent())) continue;
            ++count;
        }
        return count;
    }

    protected Key extractElementKey(ObjectManager om, Object element) {
        ApiAdapter apiAdapter = om.getApiAdapter();
        Object id = apiAdapter.getTargetKeyForSingleFieldIdentity(apiAdapter.getIdForObject(element));
        if (id == null) {
            return null;
        }
        return id instanceof Key ? (Key)id : KeyFactory.stringToKey((String)((String)id));
    }
}

