/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine;

import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.transaction.xa.XAResource;
import org.datanucleus.ConnectionFactory;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ManagedConnectionResourceListener;
import org.datanucleus.OMFContext;
import org.datanucleus.ObjectManager;
import org.datanucleus.store.appengine.DatastoreManager;
import org.datanucleus.store.appengine.DatastoreServiceFactoryInternal;
import org.datanucleus.store.appengine.DatastoreXAResource;
import org.datanucleus.store.appengine.EmulatedXAResource;

public class DatastoreConnectionFactoryImpl
implements ConnectionFactory {
    public static final String AUTO_CREATE_TXNS_PROPERTY = "datanucleus.appengine.autoCreateDatastoreTxns";
    private final OMFContext omfContext;
    private final boolean isTransactional;

    public DatastoreConnectionFactoryImpl(OMFContext omfContext, String resourceType) {
        this.omfContext = omfContext;
        this.isTransactional = omfContext.getPersistenceConfiguration().getBooleanProperty(AUTO_CREATE_TXNS_PROPERTY);
    }

    public ManagedConnection getConnection(ObjectManager om, Map options) {
        return this.omfContext.getConnectionManager().allocateConnection((ConnectionFactory)this, om, options);
    }

    public ManagedConnection createManagedConnection(ObjectManager om, Map transactionOptions) {
        return new DatastoreManagedConnection(this.newXAResource());
    }

    boolean isTransactional() {
        return this.isTransactional;
    }

    private XAResource newXAResource() {
        if (this.isTransactional()) {
            DatastoreServiceConfig config = ((DatastoreManager)this.omfContext.getStoreManager()).getDefaultDatastoreServiceConfigForWrites();
            DatastoreService datastoreService = DatastoreServiceFactoryInternal.getDatastoreService(config);
            return new DatastoreXAResource(datastoreService);
        }
        return new EmulatedXAResource();
    }

    static class DatastoreManagedConnection
    implements ManagedConnection {
        private boolean managed = false;
        private boolean locked = false;
        private final List<ManagedConnectionResourceListener> listeners = new ArrayList<ManagedConnectionResourceListener>();
        private final XAResource datastoreXAResource;

        DatastoreManagedConnection(XAResource datastoreXAResource) {
            this.datastoreXAResource = datastoreXAResource;
        }

        public Object getConnection() {
            return null;
        }

        public XAResource getXAResource() {
            return this.datastoreXAResource;
        }

        public void release() {
            if (!this.managed) {
                this.close();
            }
        }

        public void close() {
            for (ManagedConnectionResourceListener listener : this.listeners) {
                listener.managedConnectionPreClose();
            }
            for (ManagedConnectionResourceListener listener : this.listeners) {
                listener.managedConnectionPostClose();
            }
        }

        public void setManagedResource() {
            this.managed = true;
        }

        public boolean isLocked() {
            return this.locked;
        }

        public void lock() {
            this.locked = true;
        }

        public void unlock() {
            this.locked = false;
        }

        public void flush() {
            for (ManagedConnectionResourceListener listener : this.listeners) {
                listener.managedConnectionFlushed();
            }
        }

        public void addListener(ManagedConnectionResourceListener listener) {
            this.listeners.add(listener);
        }

        public void removeListener(ManagedConnectionResourceListener listener) {
            this.listeners.remove(listener);
        }
    }
}

