/*
 * Decompiled with CFR 0.152.
 */
package siena.jdbc;

import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import siena.SienaException;
import siena.Util;
import siena.jdbc.JdbcPersistenceManager;

public class PostgresqlPersistenceManager
extends JdbcPersistenceManager {
    @Override
    protected <T> List<T> fetch(Class<T> clazz, List<String> filter, List<Object> parameters, List<String> order, int limit, Object offset) {
        return this.fetch(clazz, "", " LIMIT " + limit + " offset " + offset, filter, parameters, order);
    }

    @Override
    protected void setParameter(PreparedStatement ps, int index, Object value) throws SQLException {
        if (value != null && value instanceof Date) {
            Date date = (Date)value;
            ps.setTimestamp(index, new Timestamp(date.getTime()));
        } else {
            ps.setObject(index, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void insertWithAutoIncrementKey(JdbcPersistenceManager.JdbcClassInfo classInfo, Object obj) throws SQLException, IllegalAccessException {
        ArrayList<String> keyNames = new ArrayList<String>();
        for (Field field : classInfo.generatedKeys) {
            keyNames.add(field.getName());
        }
        ResultSet gk = null;
        PreparedStatement ps = null;
        try {
            ps = this.getConnection().prepareStatement(classInfo.insertSQL + " RETURNING " + Util.join(keyNames, ","));
            this.addParameters(obj, classInfo.insertFields, ps, 1);
            gk = ps.executeQuery();
            if (!gk.next()) {
                throw new SienaException("No such generated keys");
            }
            int i = 1;
            for (Field field : classInfo.generatedKeys) {
                field.setAccessible(true);
                Util.setFromObject(obj, field, gk.getObject(i));
                ++i;
            }
        }
        catch (Throwable throwable) {
            this.closeResultSet(gk);
            this.closeStatement(ps);
            throw throwable;
        }
        this.closeResultSet(gk);
        this.closeStatement(ps);
    }
}

