/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.FileMetaData;
import org.datanucleus.metadata.PackageMetaData;
import org.datanucleus.store.AbstractAutoStartMechanism;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.exceptions.DatastoreInitialisationException;

public class MetaDataAutoStarter
extends AbstractAutoStartMechanism {
    protected String metaDataFiles;
    protected StoreManager storeMgr;
    protected ClassLoaderResolver clr;
    protected Collection classes = new HashSet();

    public MetaDataAutoStarter(StoreManager storeMgr, ClassLoaderResolver clr) {
        this.metaDataFiles = storeMgr.getOMFContext().getPersistenceConfiguration().getStringProperty("datanucleus.autoStartMetaDataFiles");
        this.storeMgr = storeMgr;
        this.clr = clr;
    }

    public Collection getAllClassData() throws DatastoreInitialisationException {
        if (this.metaDataFiles == null) {
            return Collections.EMPTY_SET;
        }
        Collection<FileMetaData> fileMetaData = this.storeMgr.getOMFContext().getMetaDataManager().loadFiles(this.metaDataFiles.split(","), this.clr);
        for (FileMetaData filemd : fileMetaData) {
            for (int i = 0; i < filemd.getNoOfPackages(); ++i) {
                PackageMetaData pmd = filemd.getPackage(i);
                for (int j = 0; j < pmd.getNoOfClasses(); ++j) {
                    ClassMetaData cmd = pmd.getClass(j);
                    this.classes.add(new StoreData(cmd.getFullClassName().trim(), null, 1, null));
                }
            }
        }
        return this.classes;
    }

    public void addClass(StoreData data) {
    }

    public void deleteClass(String className) {
    }

    public void deleteAllClasses() {
    }

    public String getStorageDescription() {
        return LOCALISER.msg("034150");
    }
}

