/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import org.jboss.virtual.VFS;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.VfsResource;
import org.springframework.util.ResourceUtils;

public abstract class AbstractFileResolvingResource
extends AbstractResource {
    public File getFile() throws IOException {
        URL url = this.getURL();
        if (url.getProtocol().startsWith("vfs")) {
            return VfsResourceDelegate.getResource(url).getFile();
        }
        return ResourceUtils.getFile(url, this.getDescription());
    }

    protected File getFileForLastModifiedCheck() throws IOException {
        URL url = this.getURL();
        if (ResourceUtils.isJarURL(url)) {
            URL actualUrl = ResourceUtils.extractJarFileURL(url);
            if (actualUrl.getProtocol().startsWith("vfs")) {
                return VfsResourceDelegate.getResource(actualUrl).getFile();
            }
            return ResourceUtils.getFile(actualUrl, "Jar URL");
        }
        return this.getFile();
    }

    protected File getFile(URI uri) throws IOException {
        if (uri.getScheme().startsWith("vfs")) {
            return VfsResourceDelegate.getResource(uri).getFile();
        }
        return ResourceUtils.getFile(uri, this.getDescription());
    }

    private static class VfsResourceDelegate {
        private VfsResourceDelegate() {
        }

        public static Resource getResource(URL url) throws IOException {
            return new VfsResource(VFS.getRoot((URL)url));
        }

        public static Resource getResource(URI uri) throws IOException {
            return new VfsResource(VFS.getRoot((URI)uri));
        }
    }
}

