/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine.query;

import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.store.appengine.DatastoreManager;
import org.datanucleus.store.appengine.FatalNucleusUserException;
import org.datanucleus.store.appengine.query.DatastoreQuery;
import org.datanucleus.store.query.AbstractJPQLQuery;
import org.datanucleus.store.query.AbstractJavaQuery;
import org.datanucleus.store.query.QueryInvalidParametersException;

public class JPQLQuery
extends AbstractJPQLQuery {
    private final DatastoreQuery datastoreQuery = new DatastoreQuery((AbstractJavaQuery)this);

    public JPQLQuery(ObjectManager om) {
        this(om, (JPQLQuery)null);
    }

    public JPQLQuery(ObjectManager om, JPQLQuery q) {
        super(om, (AbstractJPQLQuery)q);
    }

    public JPQLQuery(ObjectManager om, String query) {
        super(om, query);
    }

    protected Object performExecute(Map parameters) {
        Map params = parameters;
        return this.datastoreQuery.performExecute(LOCALISER, this.compilation, this.fromInclNo, this.toExclNo, params, false);
    }

    DatastoreQuery getDatastoreQuery() {
        return this.datastoreQuery;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    protected void checkParameterTypesAgainstCompilation(Map parameterValues) {
    }

    protected void applyImplicitParameterValueToCompilation(String name, Object value) {
        try {
            super.applyImplicitParameterValueToCompilation(name, value);
        }
        catch (QueryInvalidParametersException queryInvalidParametersException) {
            // empty catch block
        }
    }

    public void setRange(long fromIncl, long toExcl) {
        if (toExcl < 0L) {
            super.setRange(fromIncl, Long.MAX_VALUE);
        } else {
            super.setRange(fromIncl, toExcl);
        }
    }

    public void setSubclasses(boolean subclasses) {
        if (subclasses && !this.allowSubClasses()) {
            throw new FatalNucleusUserException("The App Engine datastore only supports queries that return subclass entities with the SINGLE_TABLE interitance mapping strategy.");
        }
        super.setSubclasses(subclasses);
    }

    private boolean allowSubClasses() {
        DatastoreManager storeMgr = (DatastoreManager)this.om.getStoreManager();
        ClassLoaderResolver clr = this.om.getClassLoaderResolver();
        AbstractClassMetaData acmd = storeMgr.getMetaDataManager().getMetaDataForClass(this.getCandidateClass(), clr);
        return DatastoreManager.isNewOrSuperclassTableInheritanceStrategy(acmd);
    }
}

