/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.io.protocol;

import com.google.appengine.repackaged.com.google.io.protocol.Protocol;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;

public final class ProtocolSink {
    private final byte[] buf;
    private int pos;

    public ProtocolSink(byte[] array, int offset) {
        this.buf = array;
        this.pos = offset;
    }

    public ProtocolSink(byte[] array) {
        this(array, 0);
    }

    public ProtocolSink(int size) {
        this(new byte[size], 0);
    }

    final void reset() {
        this.pos = 0;
    }

    public final int position() {
        return this.pos;
    }

    public final void skip(int n) {
        this.pos += n;
    }

    public final byte[] array() {
        return this.buf;
    }

    public final byte[] toArray() {
        byte[] copy = new byte[this.pos];
        System.arraycopy(this.buf, 0, copy, 0, this.pos);
        return copy;
    }

    public final void putBytes(byte[] src, int offset, int length) {
        System.arraycopy(src, offset, this.buf, this.pos, length);
        this.pos += length;
    }

    public final void putBytes(byte[] src) {
        this.putBytes(src, 0, src.length);
    }

    public final void putByte(byte v) {
        this.buf[this.pos++] = v;
    }

    public final void putShort(short v) {
        this.buf[this.pos++] = (byte)v;
        this.buf[this.pos++] = (byte)(v >> 8);
    }

    public final void putInt(int v) {
        this.buf[this.pos++] = (byte)v;
        this.buf[this.pos++] = (byte)(v >> 8);
        this.buf[this.pos++] = (byte)(v >> 16);
        this.buf[this.pos++] = (byte)(v >> 24);
    }

    public final void putLong(long v) {
        this.buf[this.pos++] = (byte)v;
        this.buf[this.pos++] = (byte)(v >> 8);
        this.buf[this.pos++] = (byte)(v >> 16);
        this.buf[this.pos++] = (byte)(v >> 24);
        this.buf[this.pos++] = (byte)(v >> 32);
        this.buf[this.pos++] = (byte)(v >> 40);
        this.buf[this.pos++] = (byte)(v >> 48);
        this.buf[this.pos++] = (byte)(v >> 56);
    }

    public final void putVarInt(int v) {
        while (true) {
            int bits = v & 0x7F;
            if ((v >>>= 7) == 0) {
                this.putByte((byte)bits);
                return;
            }
            this.putByte((byte)(bits | 0x80));
        }
    }

    public final void putVarLong(long v) {
        while (true) {
            int bits = (int)v & 0x7F;
            if ((v >>>= 7) == 0L) {
                this.putByte((byte)bits);
                return;
            }
            this.putByte((byte)(bits | 0x80));
        }
    }

    public final void putVarLong(int v) {
        for (int i = 0; i < 4; ++i) {
            int bits = v & 0x7F;
            if ((v >>= 7) == 0) {
                this.putByte((byte)bits);
                return;
            }
            this.putByte((byte)(bits | 0x80));
        }
        assert (-128 <= v && v <= 15);
        if (v >= 0) {
            this.putByte((byte)v);
        } else {
            this.putByte((byte)(v | 0xF0));
            this.putByte((byte)-1);
            this.putByte((byte)-1);
            this.putByte((byte)-1);
            this.putByte((byte)-1);
            this.putByte((byte)1);
        }
    }

    public final void putBoolean(boolean v) {
        if (v) {
            this.putByte((byte)1);
        } else {
            this.putByte((byte)0);
        }
    }

    public final void putFloat(float v) {
        this.putInt(Float.floatToIntBits(v));
    }

    public final void putDouble(double v) {
        this.putLong(Double.doubleToLongBits(v));
    }

    public final void putPrefixedData(byte[] v) {
        this.putVarInt(v.length);
        this.putBytes(v, 0, v.length);
    }

    public final void putForeign(ProtocolMessage message) {
        int lengthPosition = this.pos++;
        int startPosition = this.pos;
        message.outputTo(this);
        int endPosition = this.pos;
        int length = endPosition - startPosition;
        if (length < 128) {
            this.buf[lengthPosition] = (byte)length;
        } else {
            int extra = Protocol.varIntSize(length >> 7);
            System.arraycopy(this.buf, startPosition, this.buf, startPosition + extra, length);
            this.pos = lengthPosition;
            this.putVarInt(length);
            this.pos = endPosition + extra;
        }
    }
}

