package com.jispot.services.utils;

import java.util.logging.Level;
import java.util.logging.Logger;

import com.jispot.common.*;
import com.jispot.common.i18n.I18nError;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.SimpleMappingExceptionResolver;

public class SXExceptionInterceptor extends SimpleMappingExceptionResolver {

	protected final Logger log = Logger.getLogger(this.getClass().getName());

    @Override
    protected ModelAndView doResolveException( HttpServletRequest request , HttpServletResponse response ,
            Object handler , Exception ex ) {
        log.log(Level.WARNING, "An Exception has occured in the application" , ex );

        Result result = ( Result ) request.getAttribute( SXManager.RESPONSE_RESULT );
        if ( result == null ) {
            result = new Result();
        }
        Fault fault = null;
        // Let's check exceptions
        if ( ex.getCause() instanceof JISpotEx ) {
            // fault construction
            fault = new Fault( ( JISpotEx ) ex.getCause() );
        }
        else {
            // fault construction
            fault = new Fault();
            fault.setErrorCode( JISpotExCommon.C0 );
            fault.setErrorDesc( I18nError.get().getString( "jispot_error_code_" + fault.getErrorCode() ) );
            fault.setErrorDetail( ex.getMessage() + "\n" + ex.getStackTrace() );
        }
        // Mapping error code
        result.setHttp( JISpotErrorMappingProperties.getHttpCodeForError(fault.getErrorCode()) );
        // adding fault stuff
        result.addData( fault );

        request.setAttribute( SXManager.RESPONSE_RESULT , result );
        SXManager.sendResult( request , response );

        return super.doResolveException( request , response , handler , ex );
    }
}
