/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.blobstore;

import com.google.appengine.api.blobstore.BlobInfo;
import com.google.appengine.api.blobstore.BlobInfoFactory;
import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.blobstore.BlobstoreFailureException;
import com.google.appengine.api.blobstore.BlobstoreService;
import com.google.appengine.api.blobstore.BlobstoreServiceFactory;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;

public final class BlobstoreInputStream
extends InputStream {
    private final BlobKey blobKey;
    private final BlobInfo blobInfo;
    private long blobOffset;
    private byte[] buffer;
    private int bufferOffset;
    private boolean markSet = false;
    private long markOffset;
    private final BlobstoreService blobstoreService;

    public BlobstoreInputStream(BlobKey blobKey, long offset) throws IOException {
        this(blobKey, offset, new BlobInfoFactory(), BlobstoreServiceFactory.getBlobstoreService());
    }

    public BlobstoreInputStream(BlobKey blobKey) throws IOException {
        this(blobKey, 0L);
    }

    BlobstoreInputStream(BlobKey blobKey, long offset, BlobInfoFactory blobInfoFactory, BlobstoreService blobstoreService) throws IOException {
        if (offset < 0L) {
            throw new IllegalArgumentException("Offset " + offset + " is less than 0");
        }
        this.blobKey = blobKey;
        this.blobOffset = offset;
        this.blobstoreService = blobstoreService;
        this.blobInfo = blobInfoFactory.loadBlobInfo(blobKey);
        if (this.blobInfo == null) {
            throw new BlobstoreIOException("BlobstoreInputStream received an invalid blob key: " + blobKey.getKeyString());
        }
    }

    private boolean atEndOfBuffer() {
        Preconditions.checkState(this.buffer == null || this.bufferOffset <= this.buffer.length, "Buffer offset is past the end of the buffer. This should never happen.");
        return this.buffer == null || this.bufferOffset == this.buffer.length;
    }

    public int read() throws IOException {
        if (!this.ensureDataInBuffer()) {
            return -1;
        }
        return this.buffer[this.bufferOffset++] & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        Preconditions.checkNotNull(b);
        Preconditions.checkElementIndex(off, b.length);
        Preconditions.checkPositionIndex(off + len, b.length);
        if (len == 0) {
            return 0;
        }
        if (!this.ensureDataInBuffer()) {
            return -1;
        }
        int amountToCopy = Math.min(this.buffer.length - this.bufferOffset, len);
        System.arraycopy(this.buffer, this.bufferOffset, b, off, amountToCopy);
        this.bufferOffset += amountToCopy;
        return amountToCopy;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int readlimit) {
        this.markSet = true;
        this.markOffset = this.blobOffset;
        if (this.buffer != null) {
            this.markOffset += (long)(this.bufferOffset - this.buffer.length);
        }
    }

    public void reset() throws IOException {
        if (!this.markSet) {
            throw new IOException("Attempted to reset on un-mark()ed BlobstoreInputStream");
        }
        this.blobOffset = this.markOffset;
        this.buffer = null;
        this.bufferOffset = 0;
        this.markSet = false;
    }

    private boolean ensureDataInBuffer() throws IOException {
        if (!this.atEndOfBuffer()) {
            return true;
        }
        long fetchSize = Math.min(this.blobInfo.getSize() - this.blobOffset, 1015808L);
        if (fetchSize <= 0L) {
            this.buffer = null;
            return false;
        }
        try {
            this.buffer = this.blobstoreService.fetchData(this.blobKey, this.blobOffset, this.blobOffset + fetchSize - 1L);
            this.blobOffset += (long)this.buffer.length;
            this.bufferOffset = 0;
            return true;
        }
        catch (BlobstoreFailureException bfe) {
            throw new BlobstoreIOException("Error reading data from Blobstore", bfe);
        }
    }

    public static final class BlobstoreIOException
    extends IOException {
        public BlobstoreIOException(String message) {
            super(message);
        }

        public BlobstoreIOException(String message, Throwable cause) {
            super(message);
            this.initCause(cause);
        }
    }
}

