/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.springframework.core.convert.ConverterNotFoundException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.ConversionUtils;
import org.springframework.core.convert.support.GenericConversionService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CollectionToStringConverter
implements ConditionalGenericConverter {
    private static final String DELIMITER = ",";
    private final GenericConversionService conversionService;

    public CollectionToStringConverter(GenericConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Collection.class, String.class));
    }

    @Override
    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return this.conversionService.canConvert(sourceType.getElementTypeDescriptor(), targetType);
    }

    @Override
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return this.conversionService.convertNullSource(sourceType, targetType);
        }
        Collection sourceCollection = (Collection)source;
        if (sourceCollection.size() == 0) {
            return "";
        }
        TypeDescriptor sourceElementType = sourceType.getElementTypeDescriptor();
        if (sourceElementType == TypeDescriptor.NULL) {
            sourceElementType = ConversionUtils.getElementType(sourceCollection);
        }
        if (sourceElementType == TypeDescriptor.NULL || sourceElementType.isAssignableTo(targetType)) {
            StringBuilder string = new StringBuilder();
            int i = 0;
            for (Object element : sourceCollection) {
                if (i > 0) {
                    string.append(DELIMITER);
                }
                string.append(element);
                ++i;
            }
            return string.toString();
        }
        GenericConverter converter = this.conversionService.getConverter(sourceElementType, targetType);
        if (converter == null) {
            throw new ConverterNotFoundException(sourceElementType, targetType);
        }
        StringBuilder string = new StringBuilder();
        int i = 0;
        for (Object sourceElement : sourceCollection) {
            if (i > 0) {
                string.append(DELIMITER);
            }
            Object targetElement = ConversionUtils.invokeConverter(converter, sourceElement, sourceElementType, targetType);
            string.append(targetElement);
            ++i;
        }
        return string.toString();
    }
}

