/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.EntityFilter;
import com.google.appengine.api.datastore.MultiQueryComponent;
import com.google.appengine.api.datastore.MultiQueryIterator;
import com.google.appengine.api.datastore.Query;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MultiQueryBuilder
implements Iterable<List<Query>> {
    final Query baseQuery;
    final List<MultiQueryComponent> components;
    final Set<EntityFilter> entityFilters;
    final boolean hasParallelQueries;

    public MultiQueryBuilder(Query query, List<Query.FilterPredicate> remainingFilters, Set<EntityFilter> entityFilters, List<MultiQueryComponent> components) {
        if (components == null) {
            throw new NullPointerException();
        }
        this.baseQuery = MultiQueryBuilder.cloneQueryWithFilters(query, remainingFilters);
        this.components = components;
        this.entityFilters = entityFilters;
        boolean hasParallelComponents = false;
        for (MultiQueryComponent c : components) {
            if (c.getOrder() != MultiQueryComponent.Order.PARALLEL) continue;
            hasParallelComponents = true;
            break;
        }
        this.hasParallelQueries = hasParallelComponents;
    }

    static Query cloneQueryWithFilters(Query query, List<Query.FilterPredicate> filters) {
        return new Query(query.getKind(), query.getAncestor(), new ArrayList<Query.SortPredicate>(query.getSortPredicates()), new ArrayList<Query.FilterPredicate>(filters), query.isKeysOnly(), query.getAppIdNamespace(), query.getFullTextSearch());
    }

    @Override
    public Iterator<List<Query>> iterator() {
        return new MultiQueryIterator(this);
    }

    public List<Query.SortPredicate> getSortPredicates() {
        return this.baseQuery.getSortPredicates();
    }

    public boolean isKeysOnly() {
        return this.baseQuery.isKeysOnly();
    }

    public boolean hasParallelQueries() {
        return this.hasParallelQueries;
    }

    public Set<EntityFilter> getEntityFilters() {
        return this.entityFilters;
    }
}

