/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.bean.rule;

import java.beans.PropertyDescriptor;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;
import org.springmodules.validation.bean.context.ValidationContextUtils;
import org.springmodules.validation.bean.rule.ValidationRule;
import org.springmodules.validation.util.condition.AbstractCondition;
import org.springmodules.validation.util.condition.Condition;
import org.springmodules.validation.util.condition.Conditions;

public class PropertyValidationRule
implements ValidationRule {
    private String propertyName;
    private ValidationRule rule;
    private Condition applicabilityCondition;
    private String[] contextTokens;

    public PropertyValidationRule() {
        this(null, null);
    }

    public PropertyValidationRule(String propertyName, ValidationRule rule) {
        this.propertyName = propertyName;
        this.rule = rule;
        this.applicabilityCondition = new DefaultApplicabilityCondition(propertyName, rule);
        this.contextTokens = null;
    }

    public boolean isApplicable(Object obj) {
        return PropertyValidationRule.checkContext(this.contextTokens) && this.applicabilityCondition.check(obj);
    }

    public Condition getCondition() {
        return Conditions.property(this.propertyName, this.rule.getCondition());
    }

    public String getErrorCode() {
        return this.rule.getErrorCode();
    }

    public Object[] getErrorArguments(Object obj) {
        return this.rule.getErrorArguments(obj);
    }

    public String getDefaultErrorMessage() {
        return this.rule.getDefaultErrorMessage();
    }

    public void setApplicabilityCondition(Condition applicabilityCondition) {
        this.applicabilityCondition = applicabilityCondition;
    }

    public void setContextTokens(String[] contextTokens) {
        this.contextTokens = contextTokens;
    }

    protected static boolean checkContext(String[] tokens) {
        return ValidationContextUtils.tokensSupportedByCurrentContext(tokens);
    }

    protected static class DefaultApplicabilityCondition
    extends AbstractCondition {
        private String propertyName;
        private ValidationRule rule;

        public DefaultApplicabilityCondition(String propertyName, ValidationRule rule) {
            this.propertyName = propertyName;
            this.rule = rule;
        }

        public boolean doCheck(Object obj) {
            PropertyDescriptor propertyDescriptor = BeanUtils.getPropertyDescriptor(obj.getClass(), (String)this.propertyName);
            if (propertyDescriptor == null) {
                return false;
            }
            Object value = new BeanWrapperImpl(obj).getPropertyValue(this.propertyName);
            return this.rule.isApplicable(value);
        }
    }
}

