/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.util.io;

import java.io.File;
import java.io.FileFilter;
import java.util.Iterator;
import org.apache.commons.collections.iterators.ArrayIterator;
import org.springframework.util.Assert;
import org.springmodules.validation.util.collection.ReadOnlyIterator;

public class FileIterator
extends ReadOnlyIterator {
    private Iterator fileIterator;

    public FileIterator(String dirName) {
        this(new File(dirName));
    }

    public FileIterator(File dir) {
        Assert.isTrue((boolean)dir.isDirectory(), (String)"Given file must be a directory");
        this.fileIterator = new ArrayIterator((Object)dir.listFiles());
    }

    public FileIterator(String dirName, FileFilter filter) {
        this(new File(dirName), filter);
    }

    public FileIterator(File dir, FileFilter filter) {
        Assert.isTrue((boolean)dir.isDirectory(), (String)"Given file must be a directory");
        this.fileIterator = new ArrayIterator((Object)dir.listFiles(filter));
    }

    public boolean hasNext() {
        return this.fileIterator.hasNext();
    }

    public Object next() {
        return this.fileIterator.next();
    }
}

