/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.expression;

import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.mapped.expression.BooleanExpression;
import org.datanucleus.store.mapped.expression.ExistsExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;

public class CollectionSubqueryExpression
extends ScalarExpression {
    private final QueryExpression subquery;

    public CollectionSubqueryExpression(QueryExpression qs, QueryExpression subquery) {
        super(qs);
        this.subquery = subquery;
        if (subquery.getNumberOfScalarExpressions() != 1) {
            throw new NucleusUserException("Cannot use as set expression, # of selected columns != 1. Subqueries must have at most 1 column: " + subquery.toStatementText(false));
        }
        this.st.append("(").append(subquery).append(')');
    }

    public BooleanExpression containsMethod(ScalarExpression expr) {
        return expr.in(this);
    }

    public BooleanExpression isEmptyMethod() {
        return new ExistsExpression(this.qs, this.subquery, false);
    }
}

