/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.bean.conf.loader.annotation.handler.hibernate;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import org.hibernate.validator.Valid;
import org.hibernate.validator.Validator;
import org.hibernate.validator.ValidatorClass;
import org.springframework.beans.BeanUtils;
import org.springmodules.validation.bean.conf.CascadeValidation;
import org.springmodules.validation.bean.conf.MutableBeanValidationConfiguration;
import org.springmodules.validation.bean.conf.loader.annotation.handler.PropertyValidationAnnotationHandler;
import org.springmodules.validation.bean.rule.DefaultValidationRule;
import org.springmodules.validation.util.condition.AbstractCondition;
import org.springmodules.validation.util.condition.Condition;
import org.springmodules.validation.util.condition.Conditions;

public class HibernatePropertyValidationAnnotationHandler
implements PropertyValidationAnnotationHandler {
    public boolean supports(Annotation annotation, Class clazz, PropertyDescriptor descriptor) {
        Class<? extends Annotation> annotationClass = annotation.annotationType();
        ValidatorClass validatorClassAnnotation = annotationClass.getAnnotation(ValidatorClass.class);
        if (validatorClassAnnotation != null) {
            return true;
        }
        return annotation instanceof Valid;
    }

    public void handleAnnotation(Annotation annotation, Class clazz, PropertyDescriptor descriptor, MutableBeanValidationConfiguration configuration) {
        String message;
        if (annotation instanceof Valid) {
            configuration.addCascadeValidation(new CascadeValidation(descriptor.getName()));
            return;
        }
        Class<? extends Annotation> annotationClass = annotation.annotationType();
        ValidatorClass validatorClassAnnotation = annotationClass.getAnnotation(ValidatorClass.class);
        Class validatorClass = validatorClassAnnotation.value();
        Validator validator = (Validator)BeanUtils.instantiateClass((Class)validatorClass);
        validator.initialize(annotation);
        Condition condition = Conditions.property(descriptor.getName(), new HibernateValidatorCondition(validator));
        try {
            message = (String)annotationClass.getMethod("message", new Class[0]).invoke((Object)annotation, new Object[0]);
        }
        catch (NoSuchMethodException nsme) {
            message = annotationClass.getSimpleName() + ".error";
        }
        catch (IllegalAccessException e) {
            message = annotationClass.getSimpleName() + ".error";
        }
        catch (InvocationTargetException e) {
            message = annotationClass.getSimpleName() + ".error";
        }
        configuration.addPropertyRule(descriptor.getName(), new DefaultValidationRule(condition, message, message, new Object[0]));
    }

    protected static class HibernateValidatorCondition
    extends AbstractCondition {
        private Validator validator;

        public HibernateValidatorCondition(Validator validator) {
            this.validator = validator;
        }

        public boolean doCheck(Object object) {
            return this.validator.isValid(object);
        }
    }
}

