/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.util.LinkedList;
import java.util.List;
import javax.mail.event.MailEvent;

class EventQueue
implements Runnable {
    protected Thread dispatchThread;
    protected List eventQueue = new LinkedList();

    public EventQueue() {
        this.dispatchThread = new Thread((Runnable)this, "JavaMail-EventQueue");
        this.dispatchThread.setDaemon(true);
        this.dispatchThread.start();
    }

    public void run() {
        try {
            while (true) {
                PendingEvent p = this.dequeueEvent();
                if (p.event == null) {
                    return;
                }
                this.dispatchEvent(p.event, p.listeners);
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public synchronized void stop() {
        if (this.dispatchThread != null) {
            this.queueEvent(null, null);
            this.dispatchThread = null;
        }
    }

    public synchronized void queueEvent(MailEvent event, List listeners) {
        PendingEvent p = new PendingEvent(event, listeners);
        this.eventQueue.add(p);
        this.notify();
    }

    protected synchronized PendingEvent dequeueEvent() throws InterruptedException {
        while (this.eventQueue.isEmpty()) {
            this.wait();
        }
        return (PendingEvent)this.eventQueue.remove(0);
    }

    protected void dispatchEvent(MailEvent event, List listeners) {
        for (int i = 0; i < listeners.size(); ++i) {
            try {
                event.dispatch(listeners.get(i));
                continue;
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
    }

    class PendingEvent {
        MailEvent event;
        List listeners;

        PendingEvent(MailEvent event, List listeners) {
            this.event = event;
            this.listeners = listeners;
        }
    }
}

