/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.appidentity;

import com.google.appengine.api.appidentity.AppIdentityService;
import com.google.appengine.api.appidentity.AppIdentityServiceFailureException;
import com.google.appengine.api.appidentity.AppIdentityServicePb;
import com.google.appengine.api.appidentity.PublicCertificate;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.apphosting.api.ApiProxy;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AppIdentityServiceImpl
implements AppIdentityService {
    public static final String PACKAGE_NAME = "app_identity_service";
    public static final String SIGN_FOR_APP_METHOD_NAME = "SignForApp";
    public static final String GET_SERVICE_ACCOUNT_NAME_METHOD_NAME = "GetServiceAccountName";
    public static final String GET_CERTS_METHOD_NAME = "GetPublicCertificatesForApp";

    AppIdentityServiceImpl() {
    }

    private void handleApplicationError(ApiProxy.ApplicationException e) {
        switch (AppIdentityServicePb.AppIdentityServiceError.ErrorCode.valueOf(e.getApplicationError())) {
            case BLOB_TOO_LARGE: {
                throw new AppIdentityServiceFailureException(e.getErrorDetail());
            }
            case NOT_A_VALID_APP: {
                throw new AppIdentityServiceFailureException(e.getErrorDetail());
            }
            case DEADLINE_EXCEEDED: {
                throw new AppIdentityServiceFailureException(e.getErrorDetail());
            }
            case UNKNOWN_ERROR: {
                throw new AppIdentityServiceFailureException(e.getErrorDetail());
            }
        }
        throw new AppIdentityServiceFailureException(e.getErrorDetail());
    }

    public List<PublicCertificate> getPublicCertificatesForApp() {
        AppIdentityServicePb.GetPublicCertificateForAppRequest.Builder requestBuilder = AppIdentityServicePb.GetPublicCertificateForAppRequest.newBuilder();
        AppIdentityServicePb.GetPublicCertificateForAppResponse.Builder responseBuilder = AppIdentityServicePb.GetPublicCertificateForAppResponse.newBuilder();
        try {
            responseBuilder.mergeFrom(ApiProxy.makeSyncCall(PACKAGE_NAME, GET_CERTS_METHOD_NAME, requestBuilder.build().toByteArray()));
        }
        catch (ApiProxy.ApplicationException e) {
            this.handleApplicationError(e);
        }
        catch (InvalidProtocolBufferException e) {
            throw new AppIdentityServiceFailureException(e.getMessage());
        }
        AppIdentityServicePb.GetPublicCertificateForAppResponse response = responseBuilder.build();
        ArrayList<PublicCertificate> certs = Lists.newArrayList();
        for (AppIdentityServicePb.PublicCertificate cert : response.getPublicCertificateListList()) {
            certs.add(new PublicCertificate(cert.getKeyName(), cert.getX509CertificatePem()));
        }
        return certs;
    }

    @Override
    public AppIdentityService.SigningResult signForApp(byte[] signBlob) {
        AppIdentityServicePb.SignForAppRequest.Builder requestBuilder = AppIdentityServicePb.SignForAppRequest.newBuilder();
        requestBuilder.setBytesToSign(ByteString.copyFrom(signBlob));
        AppIdentityServicePb.SignForAppResponse.Builder responseBuilder = AppIdentityServicePb.SignForAppResponse.newBuilder();
        try {
            responseBuilder.mergeFrom(ApiProxy.makeSyncCall(PACKAGE_NAME, SIGN_FOR_APP_METHOD_NAME, requestBuilder.build().toByteArray()));
        }
        catch (ApiProxy.ApplicationException e) {
            this.handleApplicationError(e);
        }
        catch (InvalidProtocolBufferException e) {
            throw new AppIdentityServiceFailureException(e.getMessage());
        }
        AppIdentityServicePb.SignForAppResponse response = responseBuilder.build();
        return new AppIdentityService.SigningResult(response.getKeyName(), response.getSignatureBytes().toByteArray());
    }

    @Override
    public String getServiceAccountName() {
        AppIdentityServicePb.GetServiceAccountNameRequest.Builder requestBuilder = AppIdentityServicePb.GetServiceAccountNameRequest.newBuilder();
        AppIdentityServicePb.GetServiceAccountNameResponse.Builder responseBuilder = AppIdentityServicePb.GetServiceAccountNameResponse.newBuilder();
        try {
            responseBuilder.mergeFrom(ApiProxy.makeSyncCall(PACKAGE_NAME, GET_SERVICE_ACCOUNT_NAME_METHOD_NAME, requestBuilder.build().toByteArray()));
        }
        catch (ApiProxy.ApplicationException e) {
            this.handleApplicationError(e);
        }
        catch (InvalidProtocolBufferException e) {
            throw new AppIdentityServiceFailureException(e.getMessage());
        }
        AppIdentityServicePb.GetServiceAccountNameResponse response = responseBuilder.build();
        return response.getServiceAccountName();
    }
}

