/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.handler;

import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.util.PathMatcher;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.handler.MappedInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MappedInterceptors {
    private MappedInterceptor[] mappedInterceptors;

    public MappedInterceptors(MappedInterceptor[] mappedInterceptors) {
        this.mappedInterceptors = mappedInterceptors;
    }

    public Set<HandlerInterceptor> getInterceptors(String lookupPath, PathMatcher pathMatcher) {
        LinkedHashSet<HandlerInterceptor> interceptors = new LinkedHashSet<HandlerInterceptor>();
        MappedInterceptor[] mappedInterceptorArray = this.mappedInterceptors;
        int n = this.mappedInterceptors.length;
        int n2 = 0;
        while (n2 < n) {
            MappedInterceptor interceptor = mappedInterceptorArray[n2];
            if (this.matches(interceptor, lookupPath, pathMatcher)) {
                interceptors.add(interceptor.getInterceptor());
            }
            ++n2;
        }
        return interceptors;
    }

    private boolean matches(MappedInterceptor interceptor, String lookupPath, PathMatcher pathMatcher) {
        String[] pathPatterns = interceptor.getPathPatterns();
        if (pathPatterns != null) {
            String[] stringArray = pathPatterns;
            int n = pathPatterns.length;
            int n2 = 0;
            while (n2 < n) {
                String pattern = stringArray[n2];
                if (pathMatcher.match(pattern, lookupPath)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        return true;
    }
}

