/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.timer;

import java.util.Timer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.scheduling.timer.ScheduledTimerTask;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class TimerFactoryBean
implements FactoryBean<Timer>,
BeanNameAware,
InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ScheduledTimerTask[] scheduledTimerTasks;
    private boolean daemon = false;
    private String beanName;
    private Timer timer;

    public void setScheduledTimerTasks(ScheduledTimerTask[] scheduledTimerTasks) {
        this.scheduledTimerTasks = scheduledTimerTasks;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void afterPropertiesSet() {
        this.logger.info((Object)"Initializing Timer");
        this.timer = this.createTimer(this.beanName, this.daemon);
        if (!ObjectUtils.isEmpty((Object[])this.scheduledTimerTasks)) {
            this.registerTasks(this.scheduledTimerTasks, this.timer);
        }
    }

    protected Timer createTimer(String name, boolean daemon) {
        if (StringUtils.hasText((String)name)) {
            return new Timer(name, daemon);
        }
        return new Timer(daemon);
    }

    protected void registerTasks(ScheduledTimerTask[] tasks, Timer timer) {
        ScheduledTimerTask[] scheduledTimerTaskArray = tasks;
        int n = tasks.length;
        int n2 = 0;
        while (n2 < n) {
            ScheduledTimerTask task = scheduledTimerTaskArray[n2];
            if (task.isOneTimeTask()) {
                timer.schedule(task.getTimerTask(), task.getDelay());
            } else if (task.isFixedRate()) {
                timer.scheduleAtFixedRate(task.getTimerTask(), task.getDelay(), task.getPeriod());
            } else {
                timer.schedule(task.getTimerTask(), task.getDelay(), task.getPeriod());
            }
            ++n2;
        }
    }

    public Timer getObject() {
        return this.timer;
    }

    public Class<? extends Timer> getObjectType() {
        return Timer.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() {
        this.logger.info((Object)"Cancelling Timer");
        this.timer.cancel();
    }
}

