/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.util.condition.date;

import java.util.Calendar;
import java.util.Date;
import org.springframework.util.Assert;
import org.springmodules.validation.util.condition.date.AbstractDateCondition;

public class IsBeforeDateCondition
extends AbstractDateCondition {
    private Calendar later;

    public IsBeforeDateCondition(Date later) {
        Assert.notNull((Object)later, (String)"IsBeforeDateCondition cannot be initialized with a null date");
        this.later = Calendar.getInstance();
        this.later.setTime(later);
    }

    public IsBeforeDateCondition(Calendar later) {
        Assert.notNull((Object)later, (String)"IsBeforeDateCondition cannot be initialized with a null calendar");
        this.later = later;
    }

    protected boolean checkCalendar(Calendar calendar) {
        return this.later.getTimeInMillis() > calendar.getTimeInMillis();
    }

    public Calendar getLater() {
        return this.later;
    }
}

