/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.io.protocol;

import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.CodedInputStream;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistryLite;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.appengine.repackaged.com.google.protobuf.UninitializedMessageException;
import java.io.IOException;
import java.io.InputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Proto2BuilderAdapter<T extends ProtocolMessage<T>>
implements MessageLite.Builder {
    private T proto;
    private static final String PARSING_ERROR = "Error parsing protocol message";

    Proto2BuilderAdapter(T proto) {
        this.proto = proto;
    }

    @Override
    public MessageLite getDefaultInstanceForType() {
        return ((ProtocolMessage)this.proto).getDefaultInstanceForType();
    }

    @Override
    public MessageLite.Builder clear() {
        ((ProtocolMessage)this.proto).clear();
        return this;
    }

    @Override
    public MessageLite build() {
        if (!((ProtocolMessage)this.proto).isInitialized()) {
            throw new UninitializedMessageException(Lists.newArrayList(((ProtocolMessage)this.proto).findInitializationError()));
        }
        T result = this.proto;
        this.proto = null;
        return result;
    }

    @Override
    public MessageLite buildPartial() {
        return this.proto;
    }

    @Override
    public MessageLite.Builder clone() {
        return new Proto2BuilderAdapter<Object>(((ProtocolMessage)this.proto).clone());
    }

    @Override
    public boolean isInitialized() {
        return ((ProtocolMessage)this.proto).isInitialized();
    }

    @Override
    public MessageLite.Builder mergeFrom(CodedInputStream input) throws IOException {
        byte[] bytes;
        int messageSize = input.getBytesUntilLimit();
        if (messageSize == -1) {
            int pos = 0;
            bytes = new byte[1024];
            while (!input.isAtEnd()) {
                bytes[pos++] = input.readRawByte();
                if (pos != bytes.length) continue;
                byte[] oldBytes = bytes;
                bytes = new byte[oldBytes.length * 2];
                System.arraycopy(oldBytes, 0, bytes, 0, oldBytes.length);
            }
            messageSize = pos;
        } else {
            bytes = input.readRawBytes(messageSize);
        }
        return this.mergeFrom(bytes, 0, messageSize);
    }

    @Override
    public MessageLite.Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return this.mergeFrom(input);
    }

    @Override
    public MessageLite.Builder mergeFrom(ByteString data) throws InvalidProtocolBufferException {
        InputStream input = data.newInput();
        try {
            return this.mergeFrom(input);
        }
        catch (InvalidProtocolBufferException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public MessageLite.Builder mergeFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return this.mergeFrom(data);
    }

    @Override
    public MessageLite.Builder mergeFrom(byte[] data) throws InvalidProtocolBufferException {
        if (!((ProtocolMessage)this.proto).mergeFrom(data)) {
            throw new InvalidProtocolBufferException(PARSING_ERROR);
        }
        return this;
    }

    @Override
    public MessageLite.Builder mergeFrom(byte[] data, int off, int len) throws InvalidProtocolBufferException {
        if (!((ProtocolMessage)this.proto).mergeFrom(data, off, len)) {
            throw new InvalidProtocolBufferException(PARSING_ERROR);
        }
        return this;
    }

    @Override
    public MessageLite.Builder mergeFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return this.mergeFrom(data);
    }

    @Override
    public MessageLite.Builder mergeFrom(byte[] data, int off, int len, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return this.mergeFrom(data, off, len);
    }

    @Override
    public MessageLite.Builder mergeFrom(InputStream input) throws IOException {
        if (!((ProtocolMessage)this.proto).mergeFrom(input)) {
            throw new IOException(PARSING_ERROR);
        }
        return this;
    }

    @Override
    public MessageLite.Builder mergeFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return this.mergeFrom(input);
    }

    @Override
    public boolean mergeDelimitedFrom(InputStream input) throws IOException {
        int firstByte = input.read();
        if (firstByte == -1) {
            return false;
        }
        int size = CodedInputStream.readRawVarint32(firstByte, input);
        if (size < 0) {
            throw new IOException("Negative message size read from stream: " + size);
        }
        byte[] bytes = new byte[size];
        int remaining = size;
        int off = 0;
        while (remaining > 0) {
            int bytesRead = input.read(bytes, off, remaining);
            if (bytesRead == -1) {
                throw new IOException("EOF reached unexpectedly at position " + off);
            }
            remaining -= bytesRead;
            off += bytesRead;
        }
        this.mergeFrom(bytes);
        return true;
    }

    @Override
    public boolean mergeDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return this.mergeDelimitedFrom(input);
    }
}

