/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.oxm.jibx;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.IXMLReader;
import org.jibx.runtime.IXMLWriter;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.ValidationException;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.runtime.impl.StAXReaderWrapper;
import org.jibx.runtime.impl.StAXWriter;
import org.jibx.runtime.impl.UnmarshallingContext;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.oxm.MarshallingFailureException;
import org.springframework.oxm.UnmarshallingFailureException;
import org.springframework.oxm.ValidationFailureException;
import org.springframework.oxm.XmlMappingException;
import org.springframework.oxm.support.AbstractMarshaller;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.StaxUtils;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JibxMarshaller
extends AbstractMarshaller
implements InitializingBean {
    private Class targetClass;
    private String bindingName;
    private int indent = -1;
    private String encoding = "UTF-8";
    private Boolean standalone;
    private IBindingFactory bindingFactory;
    private TransformerFactory transformerFactory = TransformerFactory.newInstance();

    public void setTargetClass(Class targetClass) {
        this.targetClass = targetClass;
    }

    public void setBindingName(String bindingName) {
        this.bindingName = bindingName;
    }

    public void setIndent(int indent) {
        this.indent = indent;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setStandalone(Boolean standalone) {
        this.standalone = standalone;
    }

    public void afterPropertiesSet() throws JiBXException {
        Assert.notNull((Object)this.targetClass, (String)"targetClass is required");
        if (StringUtils.hasLength((String)this.bindingName)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Configured for target class [" + this.targetClass + "] using binding [" + this.bindingName + "]"));
            }
            this.bindingFactory = BindingDirectory.getFactory((String)this.bindingName, (Class)this.targetClass);
        } else {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Configured for target class [" + this.targetClass + "]"));
            }
            this.bindingFactory = BindingDirectory.getFactory((Class)this.targetClass);
        }
    }

    @Override
    public boolean supports(Class<?> clazz) {
        Assert.notNull(clazz, (String)"'clazz' must not be null");
        String[] mappedClasses = this.bindingFactory.getMappedClasses();
        String className = clazz.getName();
        String[] stringArray = mappedClasses;
        int n = mappedClasses.length;
        int n2 = 0;
        while (n2 < n) {
            String mappedClass = stringArray[n2];
            if (className.equals(mappedClass)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    protected void marshalOutputStream(Object graph, OutputStream outputStream) throws XmlMappingException, IOException {
        try {
            IMarshallingContext marshallingContext = this.createMarshallingContext();
            marshallingContext.marshalDocument(graph, this.encoding, this.standalone, outputStream);
        }
        catch (JiBXException ex) {
            throw this.convertJibxException(ex, true);
        }
    }

    @Override
    protected void marshalWriter(Object graph, Writer writer) throws XmlMappingException, IOException {
        try {
            IMarshallingContext marshallingContext = this.createMarshallingContext();
            marshallingContext.marshalDocument(graph, this.encoding, this.standalone, writer);
        }
        catch (JiBXException ex) {
            throw this.convertJibxException(ex, true);
        }
    }

    @Override
    protected void marshalXmlStreamWriter(Object graph, XMLStreamWriter streamWriter) throws XmlMappingException {
        try {
            MarshallingContext marshallingContext = (MarshallingContext)this.createMarshallingContext();
            StAXWriter xmlWriter = new StAXWriter(marshallingContext.getNamespaces(), streamWriter);
            marshallingContext.setXmlWriter((IXMLWriter)xmlWriter);
            marshallingContext.marshalDocument(graph);
        }
        catch (JiBXException ex) {
            throw this.convertJibxException(ex, false);
        }
    }

    @Override
    protected void marshalDomNode(Object graph, Node node) throws XmlMappingException {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.marshalOutputStream(graph, os);
            ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
            Transformer transformer = this.transformerFactory.newTransformer();
            transformer.transform(new StreamSource(is), new DOMResult(node));
        }
        catch (Exception ex) {
            throw new MarshallingFailureException("JiBX marshalling exception", ex);
        }
    }

    @Override
    protected void marshalSaxHandlers(Object graph, ContentHandler contentHandler, LexicalHandler lexicalHandler) throws XmlMappingException {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.marshalOutputStream(graph, os);
            ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
            Transformer transformer = this.transformerFactory.newTransformer();
            SAXResult saxResult = new SAXResult(contentHandler);
            saxResult.setLexicalHandler(lexicalHandler);
            transformer.transform(new StreamSource(is), saxResult);
        }
        catch (Exception ex) {
            throw new MarshallingFailureException("JiBX marshalling exception", ex);
        }
    }

    @Override
    protected void marshalXmlEventWriter(Object graph, XMLEventWriter eventWriter) {
        ContentHandler contentHandler = StaxUtils.createContentHandler((XMLEventWriter)eventWriter);
        this.marshalSaxHandlers(graph, contentHandler, null);
    }

    @Override
    protected Object unmarshalInputStream(InputStream inputStream) throws XmlMappingException, IOException {
        try {
            IUnmarshallingContext unmarshallingContext = this.createUnmarshallingContext();
            return unmarshallingContext.unmarshalDocument(inputStream, null);
        }
        catch (JiBXException ex) {
            throw this.convertJibxException(ex, false);
        }
    }

    @Override
    protected Object unmarshalReader(Reader reader) throws XmlMappingException, IOException {
        try {
            IUnmarshallingContext unmarshallingContext = this.createUnmarshallingContext();
            return unmarshallingContext.unmarshalDocument(reader);
        }
        catch (JiBXException ex) {
            throw this.convertJibxException(ex, false);
        }
    }

    @Override
    protected Object unmarshalXmlStreamReader(XMLStreamReader streamReader) {
        try {
            UnmarshallingContext unmarshallingContext = (UnmarshallingContext)this.createUnmarshallingContext();
            StAXReaderWrapper xmlReader = new StAXReaderWrapper(streamReader, null, true);
            unmarshallingContext.setDocument((IXMLReader)xmlReader);
            return unmarshallingContext.unmarshalElement();
        }
        catch (JiBXException ex) {
            throw this.convertJibxException(ex, false);
        }
    }

    @Override
    protected Object unmarshalXmlEventReader(XMLEventReader eventReader) {
        try {
            XMLStreamReader streamReader = StaxUtils.createEventStreamReader((XMLEventReader)eventReader);
            return this.unmarshalXmlStreamReader(streamReader);
        }
        catch (XMLStreamException ex) {
            return new UnmarshallingFailureException("JiBX unmarshalling exception", ex);
        }
    }

    @Override
    protected Object unmarshalDomNode(Node node) throws XmlMappingException {
        try {
            Transformer transformer = this.transformerFactory.newTransformer();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            transformer.transform(new DOMSource(node), new StreamResult(os));
            ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
            return this.unmarshalInputStream(is);
        }
        catch (Exception ex) {
            throw new UnmarshallingFailureException("JiBX unmarshalling exception", ex);
        }
    }

    @Override
    protected Object unmarshalSaxReader(XMLReader xmlReader, InputSource inputSource) throws XmlMappingException, IOException {
        try {
            Transformer transformer = this.transformerFactory.newTransformer();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            transformer.transform(new SAXSource(xmlReader, inputSource), new StreamResult(os));
            ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
            return this.unmarshalInputStream(is);
        }
        catch (TransformerException ex) {
            throw new UnmarshallingFailureException("JiBX unmarshalling exception", ex);
        }
    }

    protected IMarshallingContext createMarshallingContext() throws JiBXException {
        IMarshallingContext marshallingContext = this.bindingFactory.createMarshallingContext();
        marshallingContext.setIndent(this.indent);
        return marshallingContext;
    }

    protected IUnmarshallingContext createUnmarshallingContext() throws JiBXException {
        return this.bindingFactory.createUnmarshallingContext();
    }

    public XmlMappingException convertJibxException(JiBXException ex, boolean marshalling) {
        if (ex instanceof ValidationException) {
            return new ValidationFailureException("JiBX validation exception", ex);
        }
        if (marshalling) {
            return new MarshallingFailureException("JiBX marshalling exception", ex);
        }
        return new UnmarshallingFailureException("JiBX unmarshalling exception", ex);
    }
}

