/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.io.protocol;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.io.protocol.Extensions;
import java.nio.ByteBuffer;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LazyParsingExtension {
    List<ByteBuffer> raw;
    Extensions.Extension parsedAs;
    volatile Object parsed;

    static LazyParsingExtension raw(ByteBuffer raw) {
        return new LazyParsingExtension(Lists.newArrayList(raw), null, null);
    }

    static LazyParsingExtension empty(Extensions.Extension singleParsedAs) {
        return new LazyParsingExtension(null, singleParsedAs, singleParsedAs.newValue());
    }

    static <T> LazyParsingExtension parsed(Extensions.Extension<?, T> parsedAs, T parsed) {
        return new LazyParsingExtension(null, parsedAs, parsed);
    }

    private LazyParsingExtension(List<ByteBuffer> raw, Extensions.Extension parsedAs, Object parsed) {
        this.raw = raw;
        this.parsedAs = parsedAs;
        this.parsed = parsed;
    }

    public final void addRaw(ByteBuffer buffer) {
        this.merge(LazyParsingExtension.raw(buffer));
    }

    public final void merge(LazyParsingExtension other) {
        if (this.isParsed() && other.isParsed()) {
            this.parsed = this.parsedAs.merge(this.parsed, other.parsed);
        } else if (this.isParsed() && !other.isParsed()) {
            this.parsed = this.parsedAs.merge(this.parsed, other.read(this.parsedAs));
        } else if (!this.isParsed() && other.isParsed()) {
            this.parsed = other.parsedAs.merge(this.read(other.parsedAs), other.parsed);
        } else {
            this.raw.addAll(other.raw);
        }
    }

    public final <T> T read(Extensions.Extension<?, T> extension) {
        this.parseIfNeeded(extension);
        return (T)this.parsed;
    }

    public final boolean isParsed() {
        return this.parsed != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    final <T> void parseIfNeeded(Extensions.Extension<?, T> extension) {
        if (!this.isParsed()) {
            LazyParsingExtension lazyParsingExtension = this;
            synchronized (lazyParsingExtension) {
                if (!this.isParsed()) {
                    this.parsedAs = extension;
                    this.parsed = extension.readFromRepeatedTags(this.raw);
                    this.raw = null;
                }
            }
        }
        Preconditions.checkState(this.parsedAs != null);
        Preconditions.checkState(this.parsed != null);
        Preconditions.checkArgument(this.parsedAs == extension, new StringBuilder("Already parsed as a different extension. Parsed as: ").append(this.parsedAs).append(", attempting to parse as ").append(extension).append("."));
        Preconditions.checkState(this.isParsed(), "isParsed() should be true right after data is parsed.");
    }

    public final boolean equals(Object obj) {
        if (obj instanceof LazyParsingExtension) {
            LazyParsingExtension other = (LazyParsingExtension)obj;
            if (this.isParsed() && other.isParsed()) {
                return this.parsedAs == other.parsedAs && this.parsed.equals(other.parsed);
            }
            if (!this.isParsed() && !other.isParsed()) {
                return ((Object)this.raw).equals(other.raw);
            }
            if (this.isParsed()) {
                return this.parsed.equals(this.parsedAs.readFromRepeatedTags(other.raw));
            }
            return other.parsed.equals(other.parsedAs.readFromRepeatedTags(this.raw));
        }
        return false;
    }

    public final int hashCode() {
        throw new UnsupportedOperationException("hashCode is not supported for LazyParsingExtension");
    }
}

