/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.capabilities;

import com.google.appengine.api.capabilities.CapabilitiesService;
import com.google.appengine.api.capabilities.Capability;
import com.google.appengine.api.capabilities.CapabilityServicePb;
import com.google.appengine.api.capabilities.CapabilityState;
import com.google.appengine.api.capabilities.CapabilityStatus;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.apphosting.api.ApiProxy;

class CapabilitiesServiceImpl
implements CapabilitiesService {
    private static final String PACKAGE_NAME = "capability_service";
    private static final String METHOD_NAME = "IsEnabled";

    CapabilitiesServiceImpl() {
    }

    public CapabilityState getStatus(Capability capability) {
        CapabilityServicePb.IsEnabledRequest.Builder builder = CapabilityServicePb.IsEnabledRequest.newBuilder();
        builder.setPackage(capability.getPackageName());
        builder.addCapability(capability.getName());
        CapabilityServicePb.IsEnabledRequest request = builder.build();
        try {
            CapabilityStatus statusValue;
            byte[] responseBytes = ApiProxy.makeSyncCall(PACKAGE_NAME, METHOD_NAME, request.toByteArray());
            CapabilityServicePb.IsEnabledResponse response = CapabilityServicePb.IsEnabledResponse.parseFrom(responseBytes);
            CapabilityServicePb.IsEnabledResponse.SummaryStatus status = response.getSummaryStatus();
            long timeUntilScheduled = -1L;
            switch (status) {
                case ENABLED: {
                    statusValue = CapabilityStatus.ENABLED;
                    break;
                }
                case SCHEDULED_NOW: {
                    timeUntilScheduled = 0L;
                    statusValue = CapabilityStatus.SCHEDULED_MAINTENANCE;
                    break;
                }
                case SCHEDULED_FUTURE: {
                    timeUntilScheduled = response.getTimeUntilScheduled();
                    statusValue = CapabilityStatus.SCHEDULED_MAINTENANCE;
                    break;
                }
                case DISABLED: {
                    statusValue = CapabilityStatus.DISABLED;
                    break;
                }
                default: {
                    statusValue = CapabilityStatus.UNKNOWN;
                }
            }
            return new CapabilityState(capability, statusValue, timeUntilScheduled);
        }
        catch (InvalidProtocolBufferException ex) {
            throw new ApiProxy.ArgumentException(PACKAGE_NAME, METHOD_NAME);
        }
    }
}

