/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.bean.conf.loader.xml.handler;

import org.springframework.util.StringUtils;
import org.springmodules.validation.bean.conf.ValidationConfigurationException;
import org.springmodules.validation.bean.conf.loader.xml.handler.AbstractPropertyValidationElementHandler;
import org.springmodules.validation.bean.rule.AbstractValidationRule;
import org.springmodules.validation.bean.rule.MaxSizeValidationRule;
import org.springmodules.validation.bean.rule.MinSizeValidationRule;
import org.springmodules.validation.bean.rule.SizeValidationRule;
import org.w3c.dom.Element;

public class SizeRuleElementHandler
extends AbstractPropertyValidationElementHandler {
    private static final String ELEMENT_NAME = "size";
    private static final String MIN_ATTR = "min";
    private static final String MAX_ATTR = "max";

    public SizeRuleElementHandler(String namespaceUri) {
        super(ELEMENT_NAME, namespaceUri);
    }

    protected AbstractValidationRule createValidationRule(Element element) {
        Integer max;
        String minText = element.getAttribute(MIN_ATTR);
        String maxText = element.getAttribute(MAX_ATTR);
        Integer min = StringUtils.hasText((String)minText) ? new Integer(minText) : null;
        Integer n = max = StringUtils.hasText((String)maxText) ? new Integer(maxText) : null;
        if (min != null && max != null) {
            return new SizeValidationRule(min, max);
        }
        if (min != null) {
            return new MinSizeValidationRule(min);
        }
        if (max != null) {
            return new MaxSizeValidationRule(max);
        }
        throw new ValidationConfigurationException("Element 'size' must have either 'min' attribute, 'max' attribute, or both");
    }
}

