/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine.query;

import com.google.appengine.api.datastore.Entity;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.datanucleus.store.appengine.Utils;
import org.datanucleus.store.appengine.query.AbstractIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LazyResult<T>
implements Iterable<T> {
    private final Utils.Function<Entity, T> entityTransformer;
    private final Iterator<Entity> lazyEntityIterator;
    private final ArrayList<T> resolvedPojos = Utils.newArrayList(new Object[0]);

    public LazyResult(Iterable<Entity> lazyEntities, Utils.Function<Entity, T> entityTransformer) {
        this.lazyEntityIterator = lazyEntities.iterator();
        this.entityTransformer = entityTransformer;
    }

    T get(int index) {
        if (index >= this.resolvedPojos.size() && this.lazyEntityIterator.hasNext()) {
            for (int i = this.resolvedPojos.size(); i <= index && this.lazyEntityIterator.hasNext(); ++i) {
                this.resolveNext();
            }
        }
        return this.resolvedPojos.get(index);
    }

    void resolveNext() {
        this.resolvedPojos.add(this.entityTransformer.apply(this.lazyEntityIterator.next()));
    }

    @Override
    public Iterator<T> iterator() {
        return this.listIterator();
    }

    ListIterator<T> listIterator() {
        if (!this.lazyEntityIterator.hasNext()) {
            return this.resolvedPojos.listIterator();
        }
        return new LazyAbstractListIterator();
    }

    public int size() {
        this.resolveAll();
        return this.resolvedPojos.size();
    }

    void resolveAll() {
        while (this.lazyEntityIterator.hasNext()) {
            this.resolveNext();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class LazyAbstractListIterator
    extends AbstractListIterator {
        private int curIndex;

        LazyAbstractListIterator() {
            this.curIndex = 0;
        }

        @Override
        protected T computeNext() {
            if (this.curIndex >= LazyResult.this.resolvedPojos.size()) {
                if (!LazyResult.this.lazyEntityIterator.hasNext()) {
                    this.endOfData();
                    return null;
                }
                LazyResult.this.resolveNext();
            }
            return LazyResult.this.resolvedPojos.get(this.curIndex++);
        }

        Iterator<?> getInnerIterator() {
            return LazyResult.this.lazyEntityIterator;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractListIterator
    extends AbstractIterator<T>
    implements ListIterator<T> {
        private int curIndex = 0;
        private int maxIndex = 0;

        private AbstractListIterator() {
        }

        @Override
        public boolean hasPrevious() {
            return this.previousIndex() != -1;
        }

        @Override
        public T previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            Object result = LazyResult.this.resolvedPojos.get(this.previousIndex());
            --this.curIndex;
            return result;
        }

        @Override
        public int nextIndex() {
            return this.curIndex;
        }

        @Override
        public int previousIndex() {
            return this.curIndex - 1;
        }

        @Override
        public boolean hasNext() {
            return this.curIndex < this.maxIndex || super.hasNext();
        }

        @Override
        public T next() {
            if (this.curIndex < this.maxIndex) {
                return LazyResult.this.resolvedPojos.get(this.curIndex++);
            }
            Object result = super.next();
            this.maxIndex = ++this.curIndex;
            return result;
        }

        @Override
        public void set(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Object o) {
            throw new UnsupportedOperationException();
        }
    }
}

