/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedCaseInsensitiveMap;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaType
implements Comparable<MediaType> {
    public static final MediaType ALL = new MediaType("*", "*");
    private static final String WILDCARD_TYPE = "*";
    private static final String PARAM_QUALITY_FACTORY = "q";
    private static final String PARAM_CHARSET = "charset";
    private final String type;
    private final String subtype;
    private final Map<String, String> parameters;

    public MediaType(String type) {
        this(type, WILDCARD_TYPE);
    }

    public MediaType(String type, String subtype) {
        this(type, subtype, Collections.emptyMap());
    }

    public MediaType(String type, String subtype, Charset charSet) {
        this(type, subtype, Collections.singletonMap(PARAM_CHARSET, charSet.toString()));
    }

    public MediaType(String type, String subtype, Map<String, String> parameters) {
        Assert.hasText((String)type, (String)"'type' must not be empty");
        Assert.hasText((String)subtype, (String)"'subtype' must not be empty");
        this.type = type.toLowerCase(Locale.ENGLISH);
        this.subtype = subtype.toLowerCase(Locale.ENGLISH);
        if (!CollectionUtils.isEmpty(parameters)) {
            this.parameters = new LinkedCaseInsensitiveMap(parameters.size());
            this.parameters.putAll(parameters);
        } else {
            this.parameters = Collections.emptyMap();
        }
    }

    public String getType() {
        return this.type;
    }

    public boolean isWildcardType() {
        return WILDCARD_TYPE.equals(this.type);
    }

    public String getSubtype() {
        return this.subtype;
    }

    public boolean isWildcardSubtype() {
        return WILDCARD_TYPE.equals(this.subtype);
    }

    public Charset getCharSet() {
        String charSet = this.parameters.get(PARAM_CHARSET);
        return charSet != null ? Charset.forName(charSet) : null;
    }

    public double getQualityValue() {
        String qualityFactory = this.parameters.get(PARAM_QUALITY_FACTORY);
        return qualityFactory != null ? Double.parseDouble(qualityFactory) : 1.0;
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public boolean includes(MediaType other) {
        if (this == other) {
            return true;
        }
        if (this.type.equals(other.type)) {
            if (this.subtype.equals(other.subtype) || this.isWildcardSubtype()) {
                return true;
            }
            int thisPlusIdx = this.subtype.indexOf(43);
            int otherPlusIdx = other.subtype.indexOf(43);
            if (thisPlusIdx != -1 && otherPlusIdx != -1) {
                String otherSubtypeSuffix;
                String thisSubtypeNoSuffix = this.subtype.substring(0, thisPlusIdx);
                String thisSubtypeSuffix = this.subtype.substring(thisPlusIdx + 1);
                if (thisSubtypeSuffix.equals(otherSubtypeSuffix = other.subtype.substring(otherPlusIdx + 1)) && WILDCARD_TYPE.equals(thisSubtypeNoSuffix)) {
                    return true;
                }
            }
        }
        return this.isWildcardType();
    }

    @Override
    public int compareTo(MediaType other) {
        double qVal1 = this.getQualityValue();
        double qVal2 = other.getQualityValue();
        int qComp = Double.compare(qVal2, qVal1);
        if (qComp != 0) {
            return qComp;
        }
        if (this.isWildcardType() && !other.isWildcardType()) {
            return 1;
        }
        if (other.isWildcardType() && !this.isWildcardType()) {
            return -1;
        }
        if (!this.getType().equals(other.getType())) {
            return this.getType().compareTo(other.getType());
        }
        if (this.isWildcardSubtype() && !other.isWildcardSubtype()) {
            return 1;
        }
        if (other.isWildcardSubtype() && !this.isWildcardSubtype()) {
            return -1;
        }
        if (!this.getSubtype().equals(other.getSubtype())) {
            return this.getSubtype().compareTo(other.getSubtype());
        }
        double quality1 = this.getQualityValue();
        double quality2 = other.getQualityValue();
        return Double.compare(quality2, quality1);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MediaType)) {
            return false;
        }
        MediaType otherType = (MediaType)other;
        return this.type.equals(otherType.type) && this.subtype.equals(otherType.subtype) && this.parameters.equals(otherType.parameters);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.subtype.hashCode();
        result = 31 * result + this.parameters.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.appendTo(builder);
        return builder.toString();
    }

    private void appendTo(StringBuilder builder) {
        builder.append(this.type);
        builder.append('/');
        builder.append(this.subtype);
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            builder.append(';');
            builder.append(entry.getKey());
            builder.append('=');
            builder.append(entry.getValue());
        }
    }

    public static MediaType parseMediaType(String mediaType) {
        Assert.hasLength((String)mediaType, (String)"'mediaType' must not be empty");
        String[] parts = StringUtils.tokenizeToStringArray((String)mediaType, (String)";");
        String fullType = parts[0].trim();
        if (WILDCARD_TYPE.equals(fullType)) {
            fullType = "*/*";
        }
        int subIndex = fullType.indexOf(47);
        String type = fullType.substring(0, subIndex);
        String subtype = fullType.substring(subIndex + 1, fullType.length());
        LinkedHashMap<String, String> parameters = null;
        if (parts.length > 1) {
            parameters = new LinkedHashMap<String, String>(parts.length - 1);
            int i = 1;
            while (i < parts.length) {
                String part = parts[i];
                int eqIndex = part.indexOf(61);
                if (eqIndex != -1) {
                    String name = part.substring(0, eqIndex);
                    String value = part.substring(eqIndex + 1, part.length());
                    parameters.put(name, value);
                }
                ++i;
            }
        }
        return new MediaType(type, subtype, parameters);
    }

    public static List<MediaType> parseMediaTypes(String mediaTypes) {
        if (!StringUtils.hasLength((String)mediaTypes)) {
            return Collections.emptyList();
        }
        String[] tokens = mediaTypes.split(",\\s*");
        ArrayList<MediaType> result = new ArrayList<MediaType>(tokens.length);
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            result.add(MediaType.parseMediaType(token));
            ++n2;
        }
        return result;
    }

    public static String toString(Collection<MediaType> mediaTypes) {
        StringBuilder builder = new StringBuilder();
        Iterator<MediaType> iterator = mediaTypes.iterator();
        while (iterator.hasNext()) {
            MediaType mediaType = iterator.next();
            mediaType.appendTo(builder);
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        return builder.toString();
    }
}

