package com.jispot.services.utils;

import com.jispot.common.*;
import com.jispot.common.spring.UserContext;
import com.jispot.services.*;

import java.util.logging.Level;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

/**
 * This class is a controller interceptor.<br>
 * Used in order to check tenant stuff before a controller call. Checksum verification based on given request parameters
 * or attribute.
 */
public class SXInterceptor extends HandlerInterceptorAdapter {

	protected final Logger log = Logger.getLogger(this.getClass().getName());

    /**
     * Variable containing user's data stored in the "httpSession"
     */
    //@Autowired
    //protected UserContext        userContext;

    @Autowired
    protected ApplicationService applicationService;

    @Override
    public boolean preHandle( HttpServletRequest request , HttpServletResponse response , Object handler )
            throws Exception {
        log.info( "Before handling the request" );
        if ( log.isLoggable(Level.INFO) ) log.info( "********************************* SXManager START" );

        try {
            // We have to get the request in order to extract
            // the parameters : api_key api_sig
            String apiKey = RequestUtils.getAttributeOrParameter( request , SXManager.REQUEST_API_KEY );
            String apiSig = RequestUtils.getAttributeOrParameter( request , SXManager.REQUEST_API_SIG );
            if ( log.isLoggable(Level.FINEST) ) log.finest( "********************************* API_KEY : " + apiKey );
            if ( log.isLoggable(Level.FINEST) ) log.finest( "********************************* API_SIG : " + apiSig );

            // if attributes are null we cannot create a userContext so maybe this method
            // doesn't need authentication nor authorization
            // it will break inside services if it's not the case so we don't mind

//            if ( StringUtils.isNotNullOrEmpty( apiKey ) ) {
//                String secret = applicationService.getSecret( apiKey );
//
//                if ( SXManager.SX_SECURITY_ACTIV ) {
//                    String checkSum = SXManager.calculateChecksum( request , secret );
//                    if ( log.isLoggable(Level.FINEST) ) log.finest( "********************************* CHECKSUM : " + checkSum );
//
//                    // we compare the checkSum with the api_sig that was given as a parameter
//                    if ( checkSum.equals( apiSig ) ) {
//                        // We can put what we need into the userContext
//                        if ( log.isLoggable(Level.FINEST) ) log.finest( "********************************* SIGNATURE OK" );
//                        userContext.setTenantKey( appliVO.getTenantKey() );
//                    }
//                    else {
//                        if ( log.isLoggable(Level.FINEST) ) log.finest( "********************************* SIGNATURE KO" );
//                        throw new JISpotEx( JISpotExCommon.C2 , Default2MProperties.getLanguage() ,
//                                "jispot_error_sx_invalid_checksum" );
//                    }
//                }
//                else {
//                    // SX SECURITY is not activ we TRUST the request api_key to give us the correct tenant...
//                    userContext.setTenantKey( appliVO.getTenantKey() );
//                }
//            }
        }
        catch ( Exception ex ) {
            throw ex;
        }

        if ( log.isLoggable(Level.FINEST) ) log.finest( "********************************* SXManager STOP" );
        return super.preHandle( request , response , handler );
    }

    @Override
    public void postHandle( HttpServletRequest request , HttpServletResponse response , Object handler ,
            ModelAndView modelAndView ) throws Exception {
        log.info( "After handling the request" );

        // Just ask for a response with the current request and response
        SXManager.sendResult( request , response );
        super.postHandle( request , response , handler , modelAndView );
    }

}
