/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.util.fel.parser;

import org.springframework.beans.BeanWrapperImpl;
import org.springmodules.validation.util.fel.FelEvaluationException;
import org.springmodules.validation.util.fel.Function;
import org.springmodules.validation.util.fel.FunctionExpressionParser;

public class PropertyPathFunctionExpressionParser
implements FunctionExpressionParser {
    public Function parse(String expression) {
        return new PropertyPathFunction(expression);
    }

    protected class PropertyPathFunction
    implements Function {
        private String propertyPath;

        public PropertyPathFunction(String propertyPath) {
            this.propertyPath = propertyPath;
        }

        public Object evaluate(Object argument) {
            try {
                return new BeanWrapperImpl(argument).getPropertyValue(this.propertyPath);
            }
            catch (Throwable t) {
                throw new FelEvaluationException("Could not evaluate path '" + this.propertyPath + "' on bean '" + String.valueOf(argument) + "'", t);
            }
        }
    }
}

