/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.MergedBeanDefinitionPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;

class ApplicationContextAwareProcessor
implements MergedBeanDefinitionPostProcessor {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final ConfigurableApplicationContext applicationContext;
    private final Map<String, Boolean> singletonNames = new ConcurrentHashMap<String, Boolean>();

    public ApplicationContextAwareProcessor(ConfigurableApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void postProcessMergedBeanDefinition(RootBeanDefinition beanDefinition, Class beanType, String beanName) {
        if (!this.applicationContext.containsBean(beanName) && beanDefinition.isSingleton()) {
            this.singletonNames.put(beanName, Boolean.TRUE);
        }
    }

    public Object postProcessBeforeInitialization(final Object bean, final String beanName) throws BeansException {
        AccessControlContext acc = null;
        if (System.getSecurityManager() != null && (bean instanceof ResourceLoaderAware || bean instanceof ApplicationEventPublisherAware || bean instanceof MessageSourceAware || bean instanceof ApplicationContextAware)) {
            acc = this.applicationContext.getBeanFactory().getAccessControlContext();
        }
        if (acc != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    ApplicationContextAwareProcessor.this.doProcess(bean, beanName);
                    return null;
                }
            }, acc);
        } else {
            this.doProcess(bean, beanName);
        }
        return bean;
    }

    private void doProcess(Object bean, String beanName) {
        if (bean instanceof ResourceLoaderAware) {
            ((ResourceLoaderAware)bean).setResourceLoader((ResourceLoader)this.applicationContext);
        }
        if (bean instanceof ApplicationEventPublisherAware) {
            ((ApplicationEventPublisherAware)bean).setApplicationEventPublisher(this.applicationContext);
        }
        if (bean instanceof MessageSourceAware) {
            ((MessageSourceAware)bean).setMessageSource(this.applicationContext);
        }
        if (bean instanceof ApplicationContextAware) {
            ((ApplicationContextAware)bean).setApplicationContext(this.applicationContext);
        }
        if (bean instanceof ApplicationListener && !this.applicationContext.containsBean(beanName)) {
            Boolean flag = this.singletonNames.get(beanName);
            if (Boolean.TRUE.equals(flag)) {
                this.applicationContext.addApplicationListener((ApplicationListener)bean);
            } else if (flag == null) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)("Inner bean '" + beanName + "' implements ApplicationListener interface " + "but is not reachable for event multicasting by its containing ApplicationContext " + "because it does not have singleton scope. Only top-level listener beans are allowed " + "to be of non-singleton scope."));
                }
                this.singletonNames.put(beanName, Boolean.FALSE);
            }
        }
    }

    public Object postProcessAfterInitialization(Object bean, String name) {
        return bean;
    }
}

