/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.api;

import com.google.apphosting.api.ApiProxy;

public abstract class ApiStats {
    private static final String KEY = ApiStats.class.getName();

    public static ApiStats get(ApiProxy.Environment env) {
        return (ApiStats)env.getAttributes().get(KEY);
    }

    public abstract long getApiTimeInMegaCycles();

    public abstract long getCpuTimeInMegaCycles();

    protected ApiStats(ApiProxy.Environment env) {
        this.bind(env);
    }

    private void bind(ApiProxy.Environment env) {
        ApiStats original = ApiStats.get(env);
        if (original != null) {
            if (original != this) {
                throw new IllegalStateException("Cannot replace existing ApiStats object");
            }
        } else {
            env.getAttributes().put(KEY, this);
        }
    }
}

