/**
 * DEBUG CONSTANT :
 * 0 = NO DEBUG
 * 1 = INFORMATION
 * 2 = DEBUG
 * 3 = VERBOSE
 */
var com_jispot_DEBUG = 2;
/** 
 * Ajax form manager for everything in the JI Spot application.
 * What you MUST have :
 * - An id named 'body' for your body : <body id="body">
 * - An id named preffixed with your form id and suffixed with "-message" for showing the messages
 *   If your form id is : 'loginForm', your message id MUST be : 'loginForm-message'
 * - All your input must have names !!
 * 
 * Example of use : 
 * <form id="loginForm" method="POST" action="/login.url">
 * <fieldset>
 *   <legend>Connection</legend>
 *   <label id="loginForm-message" />
 *   <label for="login">Email:</label>
 *   <input id="login" name="login" type="text" />
 *
 *   <label for="password">Password:/></label>
 *   <input id="password" name="password" type="password" />
 *
 *    <button id="buttonLogin" class="submit">Let me In!</button>
 * </fieldset>
 * </form>
 * <script type="text/javascript">
 * $(document).ready(function() {
 *   new setupAjaxForm('loginForm', true);
 * });
 * </script>
 * 
 * Other options like validators or custom on_success function can be used...
 * No time for more doc... ask me directly.
 */
function setupAjaxForm(form_id, global, form_validations, on_success) {
  if (com_jispot_DEBUG >= 3) alert('>>> setupAjaxForm');
  var form = '#' + form_id;

  // Show the Loading parameter
  var showWait = function(activate) {
    if (activate == true) {
      if (global == true) $('#body').mask("Waiting...");
      else $(form).mask("Waiting...");
    }
    else {
      if (global == true) $('#body').unmask();
      else $(form).unmask();
    }
  };

  // setup jQuery Plugin 'ajaxForm'
  var options = {
    dataType : 'json', 
    timeout:    7000,
    beforeSubmit : function() {
                     // run form validations if they exist
                     if (typeof form_validations == "function" && !form_validations()) {
                       // this will prevent the form from being submitted
                       return false;
                     }
                   },
    beforeSend: function(json) { showWait(true); },
    complete:   function(json) { showWait(false);},
    error:      function(json, error, exception) { internalerror(); }, 
    success:    function(json) {
                  if (com_jispot_DEBUG >= 2) alert('>>> setupAjaxForm success function');
                  showWait(false);
                  // Waiting for a {"message":"something", "result"="OK/KO"}
                  // 'message' and 'result' must be keys
                  if (json.result != null) {
                    if (com_jispot_DEBUG >= 2) alert('json.result != null : \n' + json.result + '\n' + json.message);
                    $(form + '-message').hide();
                    //$(form + '-message').removeClass().addClass(json.result).html(json.message).fadeIn('slow');
                    $(form + '-message').html(json.message).fadeIn('slow');
                    if (json.result == 'OK') {
                      $(form).clearForm();
                      $(form + '-message').html('');
                    }
                  }                  
                  if (typeof on_success == "function") {
                    // Dedicated management of the return function
                    on_success(json);
                  }
                  if (com_jispot_DEBUG >= 2) alert('<<< setupAjaxForm success function');
                }
  };
  $(form).ajaxForm(options);
  if (com_jispot_DEBUG >= 3) alert('<<< setupAjaxForm');
}

//*********************************************************
//*********************************************************
//******* Do an action from a div ********
function doAction(url, on_function){
  if (com_jispot_DEBUG >= 3) alert('<<< doAction');
  $.ajax({
    url         : url,
    type        : 'POST',
    dataType    : 'json', 
    timeout     : 7000,
    processData : true,
    beforeSend  : function(json) { $('#bd').mask("Waiting..."); },
    complete    : function(json) { $('#bd').unmask();},
    error       : function(json, error, exception) { internalerror(); }, 
    success     : function(json){
                    $('#bd').unmask();
                    if (typeof on_function == "function") {
                      // Dedicated management of the return function
                      on_function(json);
                    }
                  }
  });
  if (com_jispot_DEBUG >= 3) alert('<<< doAction');
}
function doActionGet(url, on_function){
  if (com_jispot_DEBUG >= 3) alert('<<< doActionGet');
  $.ajax({
    url         : url,
    type        : 'GET',
    dataType    : 'json', 
    timeout     : 7000,
    processData : true,
    beforeSend  : function(json) { $('#bd').mask("Waiting..."); },
    complete    : function(json) { $('#bd').unmask();},
    error       : function(json, error, exception) { internalerror(); }, 
    success     : function(json){
                    $('#bd').unmask();
                    if (typeof on_function == "function") {
                      // Dedicated management of the return function
                      on_function(json);
                    }
                  }
  });
  if (com_jispot_DEBUG >= 3) alert('<<< doActionGet');
}


