/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine;

import com.google.appengine.api.datastore.Key;
import java.util.ArrayList;
import java.util.List;
import org.datanucleus.store.appengine.BatchManager;
import org.datanucleus.store.appengine.DatastorePersistenceHandler;
import org.datanucleus.store.appengine.DatastoreTransaction;
import org.datanucleus.store.appengine.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchDeleteManager
extends BatchManager<BatchDeleteState> {
    @Override
    String getOperation() {
        return "delete";
    }

    @Override
    void processBatchState(DatastorePersistenceHandler handler, List<BatchDeleteState> batchDeleteStateList) {
        DatastoreTransaction txn = batchDeleteStateList.get(0).txn;
        ArrayList<Object> keyList = Utils.newArrayList(new Object[0]);
        for (BatchDeleteState bds : batchDeleteStateList) {
            if (bds.txn != txn) {
                throw new IllegalStateException("Batch delete cannot involve multiple txns.");
            }
            keyList.add(bds.key);
        }
        handler.delete(txn, keyList);
    }

    static final class BatchDeleteState {
        private final DatastoreTransaction txn;
        private final Key key;

        BatchDeleteState(DatastoreTransaction txn, Key key) {
            this.txn = txn;
            this.key = key;
        }
    }
}

