/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import java.math.BigDecimal;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.store.mapped.expression.FloatingPointLiteral;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.NumericExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.SingleFieldMapping;

public class NumberMapping
extends SingleFieldMapping {
    private static BigDecimal mappingSampleValue = new BigDecimal(0.0);

    public Object getSampleValue(ClassLoaderResolver clr) {
        return mappingSampleValue;
    }

    public String getJavaTypeForDatastoreMapping(int index) {
        return ClassNameConstants.JAVA_MATH_BIGDECIMAL;
    }

    public Class getJavaType() {
        return Number.class;
    }

    public ScalarExpression newLiteral(QueryExpression qs, Object value) {
        return new FloatingPointLiteral(qs, (BigDecimal)value);
    }

    public ScalarExpression newScalarExpression(QueryExpression qs, LogicSetExpression te) {
        return new NumericExpression(qs, this, te);
    }
}

