/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.plugin;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.plugin.NonManagedPluginRegistry;
import org.datanucleus.plugin.PluginRegistry;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class PluginRegistryFactory {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());

    public static PluginRegistry newPluginRegistry(PersistenceConfiguration conf, ClassLoaderResolver clr) {
        PluginRegistry registry = null;
        String regClassName = conf.getStringProperty("datanucleus.plugin.pluginRegistryClassName");
        if (regClassName != null) {
            registry = PluginRegistryFactory.newInstance(regClassName, regClassName, clr);
        }
        if (registry != null) {
            if (NucleusLogger.PLUGIN.isDebugEnabled()) {
                NucleusLogger.PLUGIN.debug("Using PluginRegistry " + registry.getClass().getName());
            }
            return registry;
        }
        registry = PluginRegistryFactory.newInstance("org.eclipse.core.runtime.RegistryFactory", "org.datanucleus.plugin.EclipsePluginRegistry", clr);
        if (registry != null) {
            if (NucleusLogger.PLUGIN.isDebugEnabled()) {
                NucleusLogger.PLUGIN.debug("Using PluginRegistry " + registry.getClass().getName());
            }
            return registry;
        }
        if (NucleusLogger.PLUGIN.isDebugEnabled()) {
            NucleusLogger.PLUGIN.debug("Using PluginRegistry " + NonManagedPluginRegistry.class.getName());
        }
        return new NonManagedPluginRegistry(clr, conf.getStringProperty("datanucleus.plugin.pluginRegistryBundleCheck"));
    }

    private static PluginRegistry newInstance(String testClass, String pluginRegistryClass, ClassLoaderResolver clr) {
        try {
            if (clr.classForName(testClass, ObjectManagerFactoryImpl.class.getClassLoader()) == null && NucleusLogger.PLUGIN.isDebugEnabled()) {
                NucleusLogger.PLUGIN.debug(LOCALISER.msg("024005", (Object)pluginRegistryClass));
            }
            return (PluginRegistry)clr.classForName(pluginRegistryClass, ObjectManagerFactoryImpl.class.getClassLoader()).getConstructor(ClassLoaderResolver.class).newInstance(clr);
        }
        catch (Exception e) {
            if (NucleusLogger.PLUGIN.isDebugEnabled()) {
                NucleusLogger.PLUGIN.debug(LOCALISER.msg("024006", (Object)pluginRegistryClass, (Object)(e.getCause() != null ? e.getCause().getMessage() : e.getMessage())));
            }
            return null;
        }
    }
}

