/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.collect;

import com.google.appengine.repackaged.com.google.common.annotations.Beta;
import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.base.Ascii;
import com.google.appengine.repackaged.com.google.common.base.Equivalence;
import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.Objects;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Supplier;
import com.google.appengine.repackaged.com.google.common.base.Suppliers;
import com.google.appengine.repackaged.com.google.common.base.Ticker;
import com.google.appengine.repackaged.com.google.common.collect.AbstractCache;
import com.google.appengine.repackaged.com.google.common.collect.Cache;
import com.google.appengine.repackaged.com.google.common.collect.CacheLoader;
import com.google.appengine.repackaged.com.google.common.collect.CacheStats;
import com.google.appengine.repackaged.com.google.common.collect.ComputationException;
import com.google.appengine.repackaged.com.google.common.collect.ComputingCache;
import com.google.appengine.repackaged.com.google.common.collect.ComputingConcurrentHashMap;
import com.google.appengine.repackaged.com.google.common.collect.CustomConcurrentHashMap;
import com.google.appengine.repackaged.com.google.common.collect.GenericMapMaker;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableEntry;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.MapEvictionListener;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(emulated=true)
public final class MapMaker
extends GenericMapMaker<Object, Object> {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int DEFAULT_CONCURRENCY_LEVEL = 4;
    private static final int DEFAULT_EXPIRATION_NANOS = 0;
    static final Supplier<? extends AbstractCache.StatsCounter> DEFAULT_STATS_COUNTER = Suppliers.ofInstance(new AbstractCache.StatsCounter(){

        public void recordHit() {
        }

        public void recordMiss() {
        }

        public void recordEviction() {
        }

        public void recordCreate(long createTime) {
        }

        public CacheStats snapshot() {
            return EMPTY_STATS;
        }
    });
    static final CacheStats EMPTY_STATS = new CacheStats(0L, 0L, 0L, 0L, 0L);
    static final Supplier<AbstractCache.SimpleStatsCounter> CACHE_STATS_COUNTER = new Supplier<AbstractCache.SimpleStatsCounter>(){

        @Override
        public AbstractCache.SimpleStatsCounter get() {
            return new AbstractCache.SimpleStatsCounter();
        }
    };
    static final int UNSET_INT = -1;
    boolean useCustomMap;
    int initialCapacity = -1;
    int concurrencyLevel = -1;
    int maximumSize = -1;
    CustomConcurrentHashMap.Strength keyStrength;
    CustomConcurrentHashMap.Strength valueStrength;
    long expireAfterWriteNanos = -1L;
    long expireAfterAccessNanos = -1L;
    RemovalCause nullRemovalCause;
    Equivalence<Object> keyEquivalence;
    Equivalence<Object> valueEquivalence;
    Executor cleanupExecutor;
    Ticker ticker;

    private boolean useNullCache() {
        return this.nullRemovalCause == null;
    }

    @GoogleInternal
    @GwtIncompatible(value="To be supported")
    public MapMaker keyEquivalence(Equivalence<Object> equivalence) {
        return this.privateKeyEquivalence((Equivalence)equivalence);
    }

    MapMaker privateKeyEquivalence(Equivalence<Object> equivalence) {
        Preconditions.checkState(this.keyEquivalence == null, "key equivalence was already set to %s", this.keyEquivalence);
        this.keyEquivalence = Preconditions.checkNotNull(equivalence);
        this.useCustomMap = true;
        return this;
    }

    Equivalence<Object> getKeyEquivalence() {
        return Objects.firstNonNull(this.keyEquivalence, this.getKeyStrength().defaultEquivalence());
    }

    @GoogleInternal
    @GwtIncompatible(value="To be supported")
    public MapMaker valueEquivalence(Equivalence<Object> equivalence) {
        return this.privateValueEquivalence(equivalence);
    }

    MapMaker privateValueEquivalence(Equivalence<Object> equivalence) {
        Preconditions.checkState(this.valueEquivalence == null, "value equivalence was already set to %s", this.valueEquivalence);
        this.valueEquivalence = Preconditions.checkNotNull(equivalence);
        this.useCustomMap = true;
        return this;
    }

    Equivalence<Object> getValueEquivalence() {
        return Objects.firstNonNull(this.valueEquivalence, this.getValueStrength().defaultEquivalence());
    }

    public MapMaker initialCapacity(int initialCapacity) {
        Preconditions.checkState(this.initialCapacity == -1, "initial capacity was already set to %s", this.initialCapacity);
        Preconditions.checkArgument(initialCapacity >= 0);
        this.initialCapacity = initialCapacity;
        return this;
    }

    int getInitialCapacity() {
        return this.initialCapacity == -1 ? 16 : this.initialCapacity;
    }

    @Beta
    public MapMaker maximumSize(int size) {
        Preconditions.checkState(this.maximumSize == -1, "maximum size was already set to %s", this.maximumSize);
        Preconditions.checkArgument(size >= 0, "maximum size must not be negative");
        this.maximumSize = size;
        this.useCustomMap = true;
        if (this.maximumSize == 0) {
            this.nullRemovalCause = RemovalCause.SIZE;
        }
        return this;
    }

    public MapMaker concurrencyLevel(int concurrencyLevel) {
        Preconditions.checkState(this.concurrencyLevel == -1, "concurrency level was already set to %s", this.concurrencyLevel);
        Preconditions.checkArgument(concurrencyLevel > 0);
        this.concurrencyLevel = concurrencyLevel;
        return this;
    }

    int getConcurrencyLevel() {
        return this.concurrencyLevel == -1 ? 4 : this.concurrencyLevel;
    }

    MapMaker strongKeys() {
        return this.setKeyStrength(CustomConcurrentHashMap.Strength.STRONG);
    }

    @GwtIncompatible(value="java.lang.ref.WeakReference")
    public MapMaker weakKeys() {
        return this.setKeyStrength(CustomConcurrentHashMap.Strength.WEAK);
    }

    @GwtIncompatible(value="java.lang.ref.SoftReference")
    public MapMaker softKeys() {
        return this.setKeyStrength(CustomConcurrentHashMap.Strength.SOFT);
    }

    MapMaker setKeyStrength(CustomConcurrentHashMap.Strength strength) {
        Preconditions.checkState(this.keyStrength == null, "Key strength was already set to %s", new Object[]{this.keyStrength});
        this.keyStrength = Preconditions.checkNotNull(strength);
        if (strength != CustomConcurrentHashMap.Strength.STRONG) {
            this.useCustomMap = true;
        }
        return this;
    }

    CustomConcurrentHashMap.Strength getKeyStrength() {
        return Objects.firstNonNull(this.keyStrength, CustomConcurrentHashMap.Strength.STRONG);
    }

    MapMaker strongValues() {
        return this.setValueStrength(CustomConcurrentHashMap.Strength.STRONG);
    }

    @GwtIncompatible(value="java.lang.ref.WeakReference")
    public MapMaker weakValues() {
        return this.setValueStrength(CustomConcurrentHashMap.Strength.WEAK);
    }

    @GwtIncompatible(value="java.lang.ref.SoftReference")
    public MapMaker softValues() {
        return this.setValueStrength(CustomConcurrentHashMap.Strength.SOFT);
    }

    MapMaker setValueStrength(CustomConcurrentHashMap.Strength strength) {
        Preconditions.checkState(this.valueStrength == null, "Value strength was already set to %s", new Object[]{this.valueStrength});
        this.valueStrength = Preconditions.checkNotNull(strength);
        if (strength != CustomConcurrentHashMap.Strength.STRONG) {
            this.useCustomMap = true;
        }
        return this;
    }

    CustomConcurrentHashMap.Strength getValueStrength() {
        return Objects.firstNonNull(this.valueStrength, CustomConcurrentHashMap.Strength.STRONG);
    }

    @Deprecated
    MapMaker expiration(long duration, TimeUnit unit) {
        return this.expireAfterWrite(duration, unit);
    }

    public MapMaker expireAfterWrite(long duration, TimeUnit unit) {
        this.checkExpiration(duration, unit);
        this.expireAfterWriteNanos = unit.toNanos(duration);
        if (duration == 0L && this.nullRemovalCause == null) {
            this.nullRemovalCause = RemovalCause.EXPIRED;
        }
        this.useCustomMap = true;
        return this;
    }

    private void checkExpiration(long duration, TimeUnit unit) {
        Preconditions.checkState(this.expireAfterWriteNanos == -1L, "expireAfterWrite was already set to %s ns", this.expireAfterWriteNanos);
        Preconditions.checkState(this.expireAfterAccessNanos == -1L, "expireAfterAccess was already set to %s ns", this.expireAfterAccessNanos);
        Preconditions.checkArgument(duration >= 0L, "duration cannot be negative: %s %s", new Object[]{duration, unit});
    }

    long getExpireAfterWriteNanos() {
        return this.expireAfterWriteNanos == -1L ? 0L : this.expireAfterWriteNanos;
    }

    @GwtIncompatible(value="To be supported")
    public MapMaker expireAfterAccess(long duration, TimeUnit unit) {
        this.checkExpiration(duration, unit);
        this.expireAfterAccessNanos = unit.toNanos(duration);
        if (duration == 0L && this.nullRemovalCause == null) {
            this.nullRemovalCause = RemovalCause.EXPIRED;
        }
        this.useCustomMap = true;
        return this;
    }

    long getExpireAfterAccessNanos() {
        return this.expireAfterAccessNanos == -1L ? 0L : this.expireAfterAccessNanos;
    }

    @GoogleInternal
    @GwtIncompatible(value="java.util.concurrent.Executor")
    MapMaker cleanupExecutor(Executor executor) {
        Preconditions.checkState(this.cleanupExecutor == null);
        this.cleanupExecutor = Preconditions.checkNotNull(executor);
        this.useCustomMap = true;
        return this;
    }

    Executor getCleanupExecutor() {
        return this.cleanupExecutor;
    }

    @GoogleInternal
    @GwtIncompatible(value="To be supported")
    public MapMaker ticker(Ticker ticker) {
        Preconditions.checkState(this.ticker == null);
        this.ticker = Preconditions.checkNotNull(ticker);
        return this;
    }

    Ticker getTicker() {
        return Objects.firstNonNull(this.ticker, Ticker.systemTicker());
    }

    @Beta
    @GwtIncompatible(value="To be supported")
    public <K, V> GenericMapMaker<K, V> removalListener(RemovalListener<K, V> listener) {
        Preconditions.checkState(this.removalListener == null);
        MapMaker me = this;
        me.removalListener = Preconditions.checkNotNull(listener);
        this.useCustomMap = true;
        return me;
    }

    @Deprecated
    @Beta
    @GwtIncompatible(value="To be supported")
    public <K, V> GenericMapMaker<K, V> evictionListener(MapEvictionListener<K, V> listener) {
        Preconditions.checkState(this.removalListener == null);
        MapMaker me = this;
        me.removalListener = new EvictionToRemovalListener(listener);
        this.useCustomMap = true;
        return me;
    }

    @Override
    public <K, V> ConcurrentMap<K, V> makeMap() {
        if (!this.useCustomMap) {
            return new ConcurrentHashMap(this.getInitialCapacity(), 0.75f, this.getConcurrencyLevel());
        }
        return this.nullRemovalCause == null ? new CustomConcurrentHashMap(this, DEFAULT_STATS_COUNTER) : new NullConcurrentMap(this);
    }

    @Override
    @GwtIncompatible(value="CustomConcurrentHashMap")
    <K, V> CustomConcurrentHashMap<K, V> makeCustomMap() {
        return new CustomConcurrentHashMap(this, DEFAULT_STATS_COUNTER);
    }

    @Override
    @GoogleInternal
    public <K, V> Cache<K, V> makeCache(CacheLoader<? super K, V> loader) {
        return this.useNullCache() ? new ComputingCache<K, V>(this, CACHE_STATS_COUNTER, loader) : new NullCache<K, V>(this, loader);
    }

    @Override
    @Deprecated
    @GoogleInternal
    public <K, V> Cache<K, V> makeCache(Function<? super K, V> computingFunction) {
        CacheLoader<? super K, V> loader = CacheLoader.from(computingFunction);
        return this.makeCache(loader);
    }

    @Override
    public <K, V> ConcurrentMap<K, V> makeComputingMap(Function<? super K, ? extends V> computingFunction) {
        CacheLoader<? super K, ? extends V> loader = CacheLoader.from(computingFunction);
        return this.makeComputingMap(loader);
    }

    @Override
    <K, V> ConcurrentMap<K, V> makeComputingMap(CacheLoader<? super K, ? extends V> loader) {
        return this.useNullCache() ? new ComputingConcurrentHashMap.ComputingMapAdapter<K, V>(this, CACHE_STATS_COUNTER, loader) : new NullComputingConcurrentMap<K, V>(this, loader);
    }

    public String toString() {
        Objects.ToStringHelper s = Objects.toStringHelper(this);
        if (this.initialCapacity != -1) {
            s.add("initialCapacity", this.initialCapacity);
        }
        if (this.concurrencyLevel != -1) {
            s.add("concurrencyLevel", this.concurrencyLevel);
        }
        if (this.maximumSize != -1) {
            s.add("maximumSize", this.maximumSize);
        }
        if (this.expireAfterWriteNanos != -1L) {
            s.add("expireAfterWrite", this.expireAfterWriteNanos + "ns");
        }
        if (this.expireAfterAccessNanos != -1L) {
            s.add("expireAfterAccess", this.expireAfterAccessNanos + "ns");
        }
        if (this.keyStrength != null) {
            s.add("keyStrength", Ascii.toLowerCase(this.keyStrength.toString()));
        }
        if (this.valueStrength != null) {
            s.add("valueStrength", Ascii.toLowerCase(this.valueStrength.toString()));
        }
        if (this.keyEquivalence != null) {
            s.addValue("keyEquivalence");
        }
        if (this.valueEquivalence != null) {
            s.addValue("valueEquivalence");
        }
        if (this.removalListener != null) {
            s.addValue("removalListener");
        }
        if (this.cleanupExecutor != null) {
            s.addValue("cleanupExecutor");
        }
        return s.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @GoogleInternal
    static final class NullCache<K, V>
    implements Cache<K, V> {
        final NullConcurrentMap<K, V> map;
        final CacheLoader<? super K, V> loader;
        final AtomicLong computeCount = new AtomicLong();
        final AtomicLong computeTime = new AtomicLong();
        ConcurrentMap<K, V> asMap;

        NullCache(MapMaker mapMaker, CacheLoader<? super K, V> loader) {
            this.map = new NullConcurrentMap(mapMaker);
            this.loader = Preconditions.checkNotNull(loader);
        }

        @Override
        public V get(K key) {
            try {
                return this.getChecked(key);
            }
            catch (ExecutionException e) {
                throw new ComputationException(e.getCause());
            }
        }

        @Override
        public V getChecked(K key) throws ExecutionException {
            long start = System.nanoTime();
            V value = this.compute(key);
            long end = System.nanoTime();
            this.computeCount.incrementAndGet();
            this.computeTime.addAndGet(end - start);
            this.map.notifyRemoval(key, value);
            return value;
        }

        private V compute(K key) throws ExecutionException {
            Preconditions.checkNotNull(key);
            try {
                return this.loader.load(key);
            }
            catch (Throwable t) {
                throw new ExecutionException(t);
            }
        }

        @Override
        @Deprecated
        public final V apply(K key) {
            return this.get(key);
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public void invalidate(Object key) {
            Preconditions.checkNotNull(key);
        }

        @Override
        public CacheStats stats() {
            long count = this.computeCount.get();
            long time = this.computeTime.get();
            return new CacheStats(0L, count, count, time, count);
        }

        @Override
        public ImmutableList<Map.Entry<K, V>> activeEntries(int limit) {
            return ImmutableList.of();
        }

        @Override
        public ConcurrentMap<K, V> asMap() {
            ConcurrentMap<K, V> am = this.asMap;
            return am != null ? am : (this.asMap = new ComputingCache.CacheAsMap<K, V>(this.map));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class NullComputingConcurrentMap<K, V>
    extends NullConcurrentMap<K, V> {
        private static final long serialVersionUID = 0L;
        final CacheLoader<? super K, ? extends V> loader;

        NullComputingConcurrentMap(MapMaker mapMaker, CacheLoader<? super K, ? extends V> loader) {
            super(mapMaker);
            this.loader = Preconditions.checkNotNull(loader);
        }

        @Override
        public V get(Object k) {
            Object key = k;
            V value = this.compute(key);
            Preconditions.checkNotNull(value, this.loader + " returned null for key " + key + ".");
            this.notifyRemoval(key, value);
            return value;
        }

        private V compute(K key) {
            Preconditions.checkNotNull(key);
            try {
                return this.loader.load(key);
            }
            catch (ComputationException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new ComputationException(t);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NullConcurrentMap<K, V>
    extends AbstractMap<K, V>
    implements ConcurrentMap<K, V>,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final RemovalListener<K, V> removalListener;
        private final RemovalCause removalCause;

        NullConcurrentMap(MapMaker mapMaker) {
            this.removalListener = mapMaker.getRemovalListener();
            this.removalCause = mapMaker.nullRemovalCause;
        }

        @Override
        public boolean containsKey(Object key) {
            Preconditions.checkNotNull(key);
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            Preconditions.checkNotNull(value);
            return false;
        }

        @Override
        public V get(Object key) {
            Preconditions.checkNotNull(key);
            return null;
        }

        void notifyRemoval(K key, V value) {
            RemovalNotification<K, V> notification = new RemovalNotification<K, V>(key, value, this.removalCause);
            this.removalListener.onRemoval(notification);
        }

        @Override
        public V put(K key, V value) {
            Preconditions.checkNotNull(key);
            Preconditions.checkNotNull(value);
            this.notifyRemoval(key, value);
            return null;
        }

        @Override
        public V putIfAbsent(K key, V value) {
            return this.put(key, value);
        }

        @Override
        public V remove(Object key) {
            Preconditions.checkNotNull(key);
            return null;
        }

        @Override
        public boolean remove(Object key, Object value) {
            Preconditions.checkNotNull(key);
            Preconditions.checkNotNull(value);
            return false;
        }

        @Override
        public V replace(K key, V value) {
            Preconditions.checkNotNull(key);
            Preconditions.checkNotNull(value);
            return null;
        }

        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            Preconditions.checkNotNull(key);
            Preconditions.checkNotNull(oldValue);
            Preconditions.checkNotNull(newValue);
            return false;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return Collections.emptySet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class EvictionToRemovalListener<K, V>
    implements RemovalListener<K, V>,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final MapEvictionListener<K, V> evictionListener;

        public EvictionToRemovalListener(MapEvictionListener<K, V> evictionListener) {
            this.evictionListener = Preconditions.checkNotNull(evictionListener);
        }

        @Override
        public void onRemoval(RemovalNotification<K, V> notification) {
            if (notification.wasEvicted()) {
                this.evictionListener.onEviction(notification.getKey(), notification.getValue());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Beta
    public static enum RemovalCause {
        EXPLICIT{

            boolean wasEvicted() {
                return false;
            }
        }
        ,
        REPLACED{

            boolean wasEvicted() {
                return false;
            }
        }
        ,
        COLLECTED{

            boolean wasEvicted() {
                return true;
            }
        }
        ,
        EXPIRED{

            boolean wasEvicted() {
                return true;
            }
        }
        ,
        SIZE{

            boolean wasEvicted() {
                return true;
            }
        };


        abstract boolean wasEvicted();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Beta
    public static final class RemovalNotification<K, V>
    extends ImmutableEntry<K, V> {
        private static final long serialVersionUID = 0L;
        private final RemovalCause cause;

        RemovalNotification(K key, V value, RemovalCause cause) {
            super(key, value);
            this.cause = cause;
        }

        public RemovalCause getCause() {
            return this.cause;
        }

        public boolean wasEvicted() {
            return this.cause.wasEvicted();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Beta
    public static interface RemovalListener<K, V> {
        public void onRemoval(RemovalNotification<K, V> var1);
    }
}

