/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine.jpa;

import javax.jdo.PersistenceManagerFactory;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContextType;
import javax.persistence.PersistenceException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.jpa.EntityManagerImpl;
import org.datanucleus.store.appengine.DatastoreManager;
import org.datanucleus.store.appengine.EntityUtils;
import org.datanucleus.store.appengine.jpa.DatastoreEntityTransactionImpl;
import org.datanucleus.store.appengine.jpa.DatastoreJPACallbackHandler;

public class DatastoreEntityManager
extends EntityManagerImpl {
    public DatastoreEntityManager(EntityManagerFactory emf, PersistenceManagerFactory pmf, PersistenceContextType contextType) {
        super(emf, pmf, contextType);
        DatastoreManager storeMgr;
        if (this.tx != null && (storeMgr = (DatastoreManager)this.getObjectManager().getStoreManager()).connectionFactoryIsTransactional()) {
            this.tx = new DatastoreEntityTransactionImpl(this.om);
        }
    }

    public Object find(Class cls, Object key) {
        try {
            key = EntityUtils.idToInternalKey(this.getObjectManager(), cls, key, false);
        }
        catch (NucleusUserException e) {
            throw new PersistenceException((Throwable)e);
        }
        return super.find(cls, key);
    }

    public void close() {
        DatastoreJPACallbackHandler.clearAttaching();
        super.close();
    }
}

